/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.RateLimiter;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTraceOTInfo;
import datadog.trace.common.Service;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDApi {
    private static final Logger log = LoggerFactory.getLogger(DDApi.class);
    private static final String TRACES_ENDPOINT_V3 = "/v0.3/traces";
    private static final String SERVICES_ENDPOINT_V3 = "/v0.3/services";
    private static final String TRACES_ENDPOINT_V4 = "/v0.4/traces";
    private static final String SERVICES_ENDPOINT_V4 = "/v0.4/services";
    private static final long SECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toSeconds(5L);
    private final String tracesEndpoint;
    private final String servicesEndpoint;
    private final List<ResponseListener> responseListeners = new ArrayList<ResponseListener>();
    private final RateLimiter loggingRateLimiter = RateLimiter.create((double)(1.0 / (double)SECONDS_BETWEEN_ERROR_LOG));
    private final ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new MessagePackFactory());

    public DDApi(String host, int port) {
        if (this.traceEndpointAvailable("http://" + host + ":" + port + TRACES_ENDPOINT_V4) && this.serviceEndpointAvailable("http://" + host + ":" + port + SERVICES_ENDPOINT_V4)) {
            this.tracesEndpoint = "http://" + host + ":" + port + TRACES_ENDPOINT_V4;
            this.servicesEndpoint = "http://" + host + ":" + port + SERVICES_ENDPOINT_V4;
        } else {
            log.debug("API v0.4 endpoints not available. Downgrading to v0.3");
            this.tracesEndpoint = "http://" + host + ":" + port + TRACES_ENDPOINT_V3;
            this.servicesEndpoint = "http://" + host + ":" + port + SERVICES_ENDPOINT_V3;
        }
    }

    public void addResponseListener(ResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    public boolean sendTraces(List<List<DDSpan>> traces) {
        return this.putContent("traces", this.tracesEndpoint, traces, traces.size());
    }

    public boolean sendServices(Map<String, Service> services) {
        if (services == null) {
            return true;
        }
        return this.putContent("services", this.servicesEndpoint, services, services.size());
    }

    private boolean putContent(String type, String endpoint, Object content, int size) {
        try {
            HttpURLConnection httpCon = this.getHttpURLConnection(endpoint);
            OutputStream out = httpCon.getOutputStream();
            this.objectMapper.writeValue(out, content);
            out.flush();
            out.close();
            String responseString = null;
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(httpCon.getInputStream()));
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = responseReader.readLine()) != null) {
                sb.append(line);
            }
            responseReader.close();
            responseString = sb.toString();
            int responseCode = httpCon.getResponseCode();
            if (responseCode != 200) {
                if (log.isDebugEnabled()) {
                    log.debug("Error while sending {} {} to the DD agent. Status: {}, ResponseMessage: ", new Object[]{size, type, responseCode, httpCon.getResponseMessage()});
                } else if (this.loggingRateLimiter.tryAcquire()) {
                    log.warn("Error while sending {} {} to the DD agent. Status: {} (going silent for {} seconds)", new Object[]{size, type, responseCode, httpCon.getResponseMessage(), SECONDS_BETWEEN_ERROR_LOG});
                }
                return false;
            }
            log.debug("Succesfully sent {} {} to the DD agent.", (Object)size, (Object)type);
            try {
                if (null != responseString && !"".equals(responseString.trim()) && !"OK".equalsIgnoreCase(responseString.trim())) {
                    JsonNode response = this.objectMapper.readTree(responseString);
                    for (ResponseListener listener : this.responseListeners) {
                        listener.onResponse(endpoint, response);
                    }
                }
            }
            catch (IOException e) {
                log.debug("failed to parse DD agent response: " + responseString, (Throwable)e);
            }
            return true;
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while sending " + size + " " + type + " to the DD agent.", (Throwable)e);
            } else if (this.loggingRateLimiter.tryAcquire()) {
                log.warn("Error while sending {} {} to the DD agent. {}: {} (going silent for {} seconds)", new Object[]{size, type, e.getClass().getName(), e.getMessage(), SECONDS_BETWEEN_ERROR_LOG});
            }
            return false;
        }
    }

    private boolean traceEndpointAvailable(String endpoint) {
        return this.endpointAvailable(endpoint, Collections.emptyList(), true);
    }

    private boolean serviceEndpointAvailable(String endpoint) {
        return this.endpointAvailable(endpoint, Collections.emptyMap(), true);
    }

    private boolean endpointAvailable(String endpoint, Object data, boolean retry) {
        try {
            HttpURLConnection httpCon = this.getHttpURLConnection(endpoint);
            httpCon.setConnectTimeout((int)TimeUnit.SECONDS.toMillis(1L));
            httpCon.setReadTimeout((int)TimeUnit.SECONDS.toMillis(1L));
            OutputStream out = httpCon.getOutputStream();
            this.objectMapper.writeValue(out, data);
            out.flush();
            out.close();
            return httpCon.getResponseCode() == 200;
        }
        catch (IOException e) {
            if (retry) {
                return this.endpointAvailable(endpoint, data, false);
            }
            return false;
        }
    }

    private HttpURLConnection getHttpURLConnection(String endpoint) throws IOException {
        URL url = new URL(endpoint);
        HttpURLConnection httpCon = (HttpURLConnection)url.openConnection();
        httpCon.setDoOutput(true);
        httpCon.setDoInput(true);
        httpCon.setRequestMethod("PUT");
        httpCon.setRequestProperty("Content-Type", "application/msgpack");
        httpCon.setRequestProperty("Datadog-Meta-Lang", "java");
        httpCon.setRequestProperty("Datadog-Meta-Lang-Version", DDTraceOTInfo.JAVA_VERSION);
        httpCon.setRequestProperty("Datadog-Meta-Lang-Interpreter", DDTraceOTInfo.JAVA_VM_NAME);
        httpCon.setRequestProperty("Datadog-Meta-Tracer-Version", DDTraceOTInfo.VERSION);
        return httpCon;
    }

    public String toString() {
        return "DDApi { tracesEndpoint=" + this.tracesEndpoint + " }";
    }

    public static interface ResponseListener {
        public void onResponse(String var1, JsonNode var2);
    }
}

