/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.DDSpanContext;
import datadog.opentracing.DefaultLogHandler;
import datadog.opentracing.LogHandler;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.common.util.Clock;
import io.opentracing.Span;
import io.opentracing.tag.Tag;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpan
implements Span,
MutableSpan {
    private static final Logger log = LoggerFactory.getLogger(DDSpan.class);
    private final DDSpanContext context;
    private final long startTimeMicro;
    private final long startTimeNano;
    private final AtomicLong durationNano = new AtomicLong();
    private final LogHandler logHandler;
    volatile WeakReference<DDSpan> ref;

    DDSpan(long timestampMicro, DDSpanContext context) {
        this(timestampMicro, context, new DefaultLogHandler());
    }

    DDSpan(long timestampMicro, DDSpanContext context, LogHandler logHandler) {
        this.context = context;
        this.logHandler = logHandler;
        if (timestampMicro <= 0L) {
            this.startTimeMicro = Clock.currentMicroTime();
            this.startTimeNano = context.getTrace().getCurrentTimeNano();
        } else {
            this.startTimeMicro = timestampMicro;
            this.startTimeNano = 0L;
        }
        context.getTrace().registerSpan(this);
    }

    public boolean isFinished() {
        return this.durationNano.get() != 0L;
    }

    private void finishAndAddToTrace(long durationNano) {
        if (this.durationNano.compareAndSet(0L, Math.max(1L, durationNano))) {
            log.debug("Finished: {}", (Object)this);
            this.context.getTrace().addSpan(this);
        } else {
            log.debug("{} - already finished!", (Object)this);
        }
    }

    public final void finish() {
        if (this.startTimeNano > 0L) {
            this.finishAndAddToTrace(this.context.getTrace().getCurrentTimeNano() - this.startTimeNano);
        } else {
            this.finish(Clock.currentMicroTime());
        }
    }

    public final void finish(long stoptimeMicros) {
        this.finishAndAddToTrace(TimeUnit.MICROSECONDS.toNanos(stoptimeMicros - this.startTimeMicro));
    }

    public DDSpan setError(boolean error) {
        this.context.setErrorFlag(error);
        return this;
    }

    public final boolean isRootSpan() {
        return BigInteger.ZERO.equals(this.context.getParentId());
    }

    @Deprecated
    public MutableSpan getRootSpan() {
        return this.getLocalRootSpan();
    }

    public MutableSpan getLocalRootSpan() {
        return this.context().getTrace().getRootSpan();
    }

    public void setErrorMeta(Throwable error) {
        this.setError(true);
        this.setTag("error.msg", error.getMessage());
        this.setTag("error.type", error.getClass().getName());
        StringWriter errorString = new StringWriter();
        error.printStackTrace(new PrintWriter(errorString));
        this.setTag("error.stack", errorString.toString());
    }

    public final DDSpan setTag(String tag, String value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final DDSpan setTag(String tag, boolean value) {
        this.context().setTag(tag, value);
        return this;
    }

    public final DDSpan setTag(String tag, Number value) {
        this.context().setTag(tag, value);
        return this;
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        this.context().setTag(tag.getKey(), value);
        return this;
    }

    public final DDSpanContext context() {
        return this.context;
    }

    public final String getBaggageItem(String key) {
        return this.context.getBaggageItem(key);
    }

    public final DDSpan setBaggageItem(String key, String value) {
        this.context.setBaggageItem(key, value);
        return this;
    }

    public final DDSpan setOperationName(String operationName) {
        this.context().setOperationName(operationName);
        return this;
    }

    public final DDSpan log(Map<String, ?> map) {
        this.logHandler.log(map, this);
        return this;
    }

    public final DDSpan log(long l, Map<String, ?> map) {
        this.logHandler.log(l, map, this);
        return this;
    }

    public final DDSpan log(String s) {
        this.logHandler.log(s, this);
        return this;
    }

    public final DDSpan log(long l, String s) {
        this.logHandler.log(l, s, this);
        return this;
    }

    public final DDSpan setServiceName(String serviceName) {
        this.context().setServiceName(serviceName);
        return this;
    }

    public final DDSpan setResourceName(String resourceName) {
        this.context().setResourceName(resourceName);
        return this;
    }

    public final DDSpan setSamplingPriority(int newPriority) {
        this.context().setSamplingPriority(newPriority);
        return this;
    }

    public final DDSpan setSpanType(String type) {
        this.context().setSpanType(type);
        return this;
    }

    public Map<String, String> getMeta() {
        HashMap<String, String> meta = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.context().getBaggageItems().entrySet()) {
            meta.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.getTags().entrySet()) {
            meta.put(entry.getKey(), String.valueOf(entry.getValue()));
        }
        return meta;
    }

    public Map<String, Number> getMetrics() {
        return this.context.getMetrics();
    }

    public long getStartTime() {
        return this.startTimeNano > 0L ? this.startTimeNano : TimeUnit.MICROSECONDS.toNanos(this.startTimeMicro);
    }

    public long getDurationNano() {
        return this.durationNano.get();
    }

    public String getServiceName() {
        return this.context.getServiceName();
    }

    public BigInteger getTraceId() {
        return this.context.getTraceId();
    }

    public BigInteger getSpanId() {
        return this.context.getSpanId();
    }

    public BigInteger getParentId() {
        return this.context.getParentId();
    }

    public String getResourceName() {
        return this.context.getResourceName();
    }

    public String getOperationName() {
        return this.context.getOperationName();
    }

    public Integer getSamplingPriority() {
        int samplingPriority = this.context.getSamplingPriority();
        if (samplingPriority == Integer.MIN_VALUE) {
            return null;
        }
        return samplingPriority;
    }

    public String getSpanType() {
        return this.context.getSpanType();
    }

    public Map<String, Object> getTags() {
        return this.context().getTags();
    }

    public String getType() {
        return this.context.getSpanType();
    }

    public Boolean isError() {
        return this.context.getErrorFlag();
    }

    public int getError() {
        return this.context.getErrorFlag() ? 1 : 0;
    }

    public String toString() {
        return this.context.toString() + ", duration_ns=" + this.durationNano;
    }
}

