/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.common.exec.CommonTaskExecutor;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTracer;
import datadog.opentracing.scopemanager.ContinuableScope;
import datadog.trace.common.util.Clock;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
extends ConcurrentLinkedDeque<DDSpan> {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private static final AtomicReference<SpanCleaner> SPAN_CLEANER = new AtomicReference();
    private final DDTracer tracer;
    private final BigInteger traceId;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Set<WeakReference<?>> weakReferences = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger pendingReferenceCount = new AtomicInteger(0);
    private final AtomicInteger completedSpanCount = new AtomicInteger(0);
    private final AtomicReference<WeakReference<DDSpan>> rootSpan = new AtomicReference();
    private final AtomicBoolean isWritten = new AtomicBoolean(false);

    PendingTrace(DDTracer tracer, BigInteger traceId) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.startTimeNano = Clock.currentNanoTime();
        this.startNanoTicks = Clock.currentNanoTicks();
        this.addPendingTrace();
    }

    public long getCurrentTimeNano() {
        return this.startTimeNano + Math.max(0L, Clock.currentNanoTicks() - this.startNanoTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpan(DDSpan span) {
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to register span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.context().getTraceId())) {
            log.debug("{} - span registered for wrong trace ({})", (Object)span, (Object)this.traceId);
            return;
        }
        this.rootSpan.compareAndSet(null, new WeakReference<DDSpan>(span));
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                span.ref = new WeakReference<DDSpan>(span, this.referenceQueue);
                this.weakReferences.add(span.ref);
                int count = this.pendingReferenceCount.incrementAndGet();
                log.debug("traceId: {} -- registered span {}. count = {}", new Object[]{this.traceId, span, count});
            } else {
                log.debug("span {} already registered in trace {}", (Object)span, (Object)this.traceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSpan(DDSpan span) {
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to expire span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.context().getTraceId())) {
            log.debug("{} - span expired for wrong trace ({})", (Object)span, (Object)this.traceId);
            return;
        }
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                log.debug("span {} not registered in trace {}", (Object)span, (Object)this.traceId);
            } else {
                this.weakReferences.remove(span.ref);
                span.ref.clear();
                span.ref = null;
                this.expireReference();
            }
        }
    }

    public void addSpan(DDSpan span) {
        if (span.getDurationNano() == 0L) {
            log.debug("{} - added to trace, but not complete.", (Object)span);
            return;
        }
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to add span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.getTraceId())) {
            log.debug("{} - added to a mismatched trace.", (Object)span);
            return;
        }
        if (!this.isWritten.get()) {
            this.addFirst(span);
        } else {
            log.debug("{} - finished after trace reported.", (Object)span);
        }
        this.expireSpan(span);
    }

    public DDSpan getRootSpan() {
        WeakReference<DDSpan> rootRef = this.rootSpan.get();
        return rootRef == null ? null : (DDSpan)rootRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref == null) {
                continuation.ref = new WeakReference<ContinuableScope.Continuation>(continuation, this.referenceQueue);
                this.weakReferences.add(continuation.ref);
                int count = this.pendingReferenceCount.incrementAndGet();
                log.debug("traceId: {} -- registered continuation {}. count = {}", new Object[]{this.traceId, continuation, count});
            } else {
                log.debug("continuation {} already registered in trace {}", (Object)continuation, (Object)this.traceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref == null) {
                log.debug("continuation {} not registered in trace {}", (Object)continuation, (Object)this.traceId);
            } else {
                this.weakReferences.remove(continuation.ref);
                continuation.ref.clear();
                continuation.ref = null;
                this.expireReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireReference() {
        int count = this.pendingReferenceCount.decrementAndGet();
        if (count == 0) {
            this.write();
        } else if (this.tracer.getPartialFlushMinSpans() > 0 && this.size() > this.tracer.getPartialFlushMinSpans()) {
            PendingTrace pendingTrace = this;
            synchronized (pendingTrace) {
                if (this.size() > this.tracer.getPartialFlushMinSpans()) {
                    DDSpan rootSpan = this.getRootSpan();
                    ArrayList<DDSpan> partialTrace = new ArrayList<DDSpan>(this.size());
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        DDSpan span = (DDSpan)it.next();
                        if (span == rootSpan) continue;
                        partialTrace.add(span);
                        this.completedSpanCount.decrementAndGet();
                        it.remove();
                    }
                    log.debug("Writing partial trace {} of size {}", (Object)this.traceId, (Object)partialTrace.size());
                    this.tracer.write(partialTrace);
                }
            }
        }
        log.debug("traceId: {} -- Expired reference. count = {}", (Object)this.traceId, (Object)count);
    }

    private synchronized void write() {
        if (this.isWritten.compareAndSet(false, true)) {
            this.removePendingTrace();
            if (!this.isEmpty()) {
                log.debug("Writing {} spans to {}.", (Object)this.size(), (Object)this.tracer.writer);
                this.tracer.write(this);
            }
        }
    }

    public synchronized boolean clean() {
        Reference ref;
        int count = 0;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.weakReferences.remove(ref);
            if (this.isWritten.compareAndSet(false, true)) {
                this.removePendingTrace();
                this.tracer.incrementTraceCount();
            }
            ++count;
            this.expireReference();
        }
        if (count > 0) {
            log.debug("trace {} : {} unfinished spans garbage collected. Trace will not report.", (Object)this.traceId, (Object)count);
        }
        return count > 0;
    }

    @Override
    public void addFirst(DDSpan span) {
        super.addFirst(span);
        this.completedSpanCount.incrementAndGet();
    }

    @Override
    public int size() {
        return this.completedSpanCount.get();
    }

    private void addPendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.add(this);
        }
    }

    private void removePendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.remove(this);
        }
    }

    static void initialize() {
        SpanCleaner oldCleaner = SPAN_CLEANER.getAndSet(new SpanCleaner());
        if (oldCleaner != null) {
            oldCleaner.close();
        }
    }

    static void close() {
        SpanCleaner cleaner = SPAN_CLEANER.getAndSet(null);
        if (cleaner != null) {
            cleaner.close();
        }
    }

    private static class SpanCleanerTask
    implements CommonTaskExecutor.Task<SpanCleaner> {
        static final SpanCleanerTask INSTANCE = new SpanCleanerTask();

        private SpanCleanerTask() {
        }

        @Override
        public void run(SpanCleaner target) {
            target.run();
        }
    }

    private static class SpanCleaner
    implements Runnable,
    Closeable {
        private static final long CLEAN_FREQUENCY = 1L;
        private final Set<PendingTrace> pendingTraces = Collections.newSetFromMap(new ConcurrentHashMap());

        public SpanCleaner() {
            CommonTaskExecutor.INSTANCE.scheduleAtFixedRate(SpanCleanerTask.INSTANCE, this, 0L, 1L, TimeUnit.SECONDS, "Pending trace cleaner");
        }

        @Override
        public void run() {
            for (PendingTrace trace : this.pendingTraces) {
                trace.clean();
            }
        }

        @Override
        public void close() {
            this.run();
        }
    }
}

