/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing.decorators;

import datadog.opentracing.decorators.AbstractDecorator;
import datadog.opentracing.decorators.DBTypeDecorator;
import datadog.opentracing.decorators.ForceManualDropDecorator;
import datadog.opentracing.decorators.ForceManualKeepDecorator;
import datadog.opentracing.decorators.PeerServiceDecorator;
import datadog.opentracing.decorators.ServiceNameDecorator;
import datadog.opentracing.decorators.ServletContextDecorator;
import datadog.trace.api.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDDecoratorsFactory {
    private static final Logger log = LoggerFactory.getLogger(DDDecoratorsFactory.class);

    public static List<AbstractDecorator> createBuiltinDecorators() {
        ArrayList<AbstractDecorator> decorators = new ArrayList<AbstractDecorator>();
        for (AbstractDecorator decorator : Arrays.asList(new DBTypeDecorator(), new ForceManualDropDecorator(), new ForceManualKeepDecorator(), new PeerServiceDecorator(), new ServiceNameDecorator(), new ServiceNameDecorator("service", false), new ServletContextDecorator())) {
            if (Config.get().isRuleEnabled(decorator.getClass().getSimpleName())) {
                decorators.add(decorator);
                continue;
            }
            log.debug("{} disabled", (Object)decorator.getClass().getSimpleName());
        }
        for (String splitByTag : Config.get().getSplitByTags()) {
            decorators.add(new ServiceNameDecorator(splitByTag, true));
        }
        return decorators;
    }
}

