/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.processor.rule;

import datadog.opentracing.DDSpan;
import datadog.opentracing.DDSpanContext;
import datadog.trace.common.processor.TraceProcessor;
import io.opentracing.tag.Tags;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;

public class URLAsResourceNameRule
implements TraceProcessor.Rule {
    public static final Pattern PATH_MIXED_ALPHANUMERICS = Pattern.compile("(?<=/)(?![vV]\\d{1,2}/)(?:[^\\/\\d\\?]*[\\d]+[^\\/\\?]*)");

    @Override
    public String[] aliases() {
        return new String[]{"URLAsResourceName"};
    }

    @Override
    public void processSpan(DDSpan span, Map<String, Object> tags, Collection<DDSpan> trace) {
        DDSpanContext context = span.context();
        Object httpStatus = tags.get(Tags.HTTP_STATUS.getKey());
        if (context.isResourceNameSet() || tags.get(Tags.HTTP_URL.getKey()) == null || httpStatus != null && (httpStatus.equals(404) || httpStatus.equals("404"))) {
            return;
        }
        String rawPath = this.rawPathFromUrlString(tags.get(Tags.HTTP_URL.getKey()).toString().trim());
        String normalizedPath = this.normalizePath(rawPath);
        String resourceName = this.addMethodIfAvailable(tags, normalizedPath);
        context.setResourceName(resourceName);
    }

    private String rawPathFromUrlString(String url) {
        if (url.isEmpty()) {
            return "/";
        }
        int queryLoc = url.indexOf("?");
        int fragmentLoc = url.indexOf("#");
        int endLoc = queryLoc < 0 ? (fragmentLoc < 0 ? url.length() : fragmentLoc) : (fragmentLoc < 0 ? queryLoc : Math.min(queryLoc, fragmentLoc));
        int protoLoc = url.indexOf("://");
        if (protoLoc < 0) {
            return url.substring(0, endLoc);
        }
        int pathLoc = url.indexOf("/", protoLoc + 3);
        if (pathLoc < 0) {
            return "/";
        }
        if (queryLoc < 0) {
            return url.substring(pathLoc);
        }
        return url.substring(pathLoc, endLoc);
    }

    private String normalizePath(String path) {
        if (path.isEmpty() || path.equals("/")) {
            return "/";
        }
        return PATH_MIXED_ALPHANUMERICS.matcher(path).replaceAll("?");
    }

    private String addMethodIfAvailable(Map<String, Object> meta, String path) {
        String verb;
        Object method = meta.get(Tags.HTTP_METHOD.getKey());
        if (method != null && !(verb = method.toString().toUpperCase().trim()).isEmpty()) {
            path = verb + " " + path;
        }
        return path;
    }
}

