/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import datadog.common.exec.DaemonThreadFactory;
import datadog.trace.common.writer.ddagent.DisruptorEvent;
import java.io.Closeable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractDisruptor<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractDisruptor.class);
    protected final Disruptor<DisruptorEvent<T>> disruptor;
    public volatile boolean running = false;
    protected final DisruptorEvent.FlushTranslator<T> flushTranslator = new DisruptorEvent.FlushTranslator();
    protected final DisruptorEvent.DataTranslator<T> dataTranslator = new DisruptorEvent.DataTranslator();

    public AbstractDisruptor(int disruptorSize, EventHandler<DisruptorEvent<T>> handler) {
        this.disruptor = new Disruptor(new DisruptorEvent.Factory(), Math.max(2, Integer.highestOneBit(disruptorSize - 1) << 1), (ThreadFactory)this.getThreadFactory(), ProducerType.MULTI, (WaitStrategy)new SleepingWaitStrategy(0, TimeUnit.MILLISECONDS.toNanos(5L)));
        this.disruptor.handleEventsWith(new EventHandler[]{handler});
    }

    protected abstract DaemonThreadFactory getThreadFactory();

    public void start() {
        this.disruptor.start();
        this.running = true;
    }

    @Override
    public void close() {
        this.running = false;
        this.disruptor.shutdown();
    }

    public abstract boolean publish(T var1, int var2);

    public boolean flush(int traceCount) {
        if (this.running) {
            return this.flush(traceCount, new CountDownLatch(1));
        }
        return false;
    }

    protected boolean flush(int traceCount, CountDownLatch latch) {
        log.info("Flushing any remaining traces.");
        this.disruptor.publishEvent(this.flushTranslator, (Object)traceCount, (Object)latch);
        try {
            latch.await();
            return true;
        }
        catch (InterruptedException e) {
            log.warn("Waiting for flush interrupted.", (Throwable)e);
            return false;
        }
    }

    public final long getDisruptorCapacity() {
        return this.disruptor.getRingBuffer().getBufferSize();
    }

    public final long getDisruptorRemainingCapacity() {
        return this.disruptor.getRingBuffer().remainingCapacity();
    }

    public final long getCurrentCount() {
        return this.disruptor.getCursor() - this.disruptor.getRingBuffer().getMinimumGatingSequence();
    }
}

