/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.timgroup.statsd.NonBlockingStatsDClient;
import com.timgroup.statsd.StatsDClient;
import datadog.opentracing.DDSpan;
import datadog.opentracing.DDTraceOTInfo;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import java.util.List;

public interface Monitor {
    public void onStart(DDAgentWriter var1);

    public void onShutdown(DDAgentWriter var1, boolean var2);

    public void onPublish(DDAgentWriter var1, List<DDSpan> var2);

    public void onFailedPublish(DDAgentWriter var1, List<DDSpan> var2);

    public void onFlush(DDAgentWriter var1, boolean var2);

    public void onScheduleFlush(DDAgentWriter var1, boolean var2);

    public void onSerialize(DDAgentWriter var1, List<DDSpan> var2, byte[] var3);

    public void onFailedSerialize(DDAgentWriter var1, List<DDSpan> var2, Throwable var3);

    public void onSend(DDAgentWriter var1, int var2, int var3, DDAgentApi.Response var4);

    public void onFailedSend(DDAgentWriter var1, int var2, int var3, DDAgentApi.Response var4);

    public static final class Noop
    implements Monitor {
        @Override
        public void onStart(DDAgentWriter agentWriter) {
        }

        @Override
        public void onShutdown(DDAgentWriter agentWriter, boolean flushSuccess) {
        }

        @Override
        public void onPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
        }

        @Override
        public void onFailedPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
        }

        @Override
        public void onFlush(DDAgentWriter agentWriter, boolean early) {
        }

        @Override
        public void onScheduleFlush(DDAgentWriter agentWriter, boolean previousIncomplete) {
        }

        @Override
        public void onSerialize(DDAgentWriter agentWriter, List<DDSpan> trace, byte[] serializedTrace) {
        }

        @Override
        public void onFailedSerialize(DDAgentWriter agentWriter, List<DDSpan> trace, Throwable optionalCause) {
        }

        @Override
        public void onSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        }

        @Override
        public void onFailedSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
        }

        public String toString() {
            return "NoOp";
        }
    }

    public static final class StatsD
    implements Monitor {
        public static final String PREFIX = "datadog.tracer";
        public static final String LANG_TAG = "lang";
        public static final String LANG_VERSION_TAG = "lang_version";
        public static final String LANG_INTERPRETER_TAG = "lang_interpreter";
        public static final String LANG_INTERPRETER_VENDOR_TAG = "lang_interpreter_vendor";
        public static final String TRACER_VERSION_TAG = "tracer_version";
        private final String hostInfo;
        private final StatsDClient statsd;

        public StatsD(String host, int port) {
            this.hostInfo = host + ":" + port;
            this.statsd = new NonBlockingStatsDClient(PREFIX, host, port, StatsD.getDefaultTags());
        }

        private StatsD(StatsDClient statsd) {
            this.hostInfo = null;
            this.statsd = statsd;
        }

        protected static final String[] getDefaultTags() {
            return new String[]{StatsD.tag(LANG_TAG, "java"), StatsD.tag(LANG_VERSION_TAG, DDTraceOTInfo.JAVA_VERSION), StatsD.tag(LANG_INTERPRETER_TAG, DDTraceOTInfo.JAVA_VM_NAME), StatsD.tag(LANG_INTERPRETER_VENDOR_TAG, DDTraceOTInfo.JAVA_VM_VENDOR), StatsD.tag(TRACER_VERSION_TAG, DDTraceOTInfo.VERSION)};
        }

        private static String tag(String tagPrefix, String tagValue) {
            return tagPrefix + ":" + tagValue;
        }

        @Override
        public void onStart(DDAgentWriter agentWriter) {
            this.statsd.recordGaugeValue("queue.max_length", agentWriter.getDisruptorCapacity(), new String[0]);
        }

        @Override
        public void onShutdown(DDAgentWriter agentWriter, boolean flushSuccess) {
        }

        @Override
        public void onPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
            this.statsd.incrementCounter("queue.accepted", new String[0]);
            this.statsd.count("queue.accepted_lengths", (long)trace.size(), new String[0]);
        }

        @Override
        public void onFailedPublish(DDAgentWriter agentWriter, List<DDSpan> trace) {
            this.statsd.incrementCounter("queue.dropped", new String[0]);
        }

        @Override
        public void onScheduleFlush(DDAgentWriter agentWriter, boolean previousIncomplete) {
        }

        @Override
        public void onFlush(DDAgentWriter agentWriter, boolean early) {
        }

        @Override
        public void onSerialize(DDAgentWriter agentWriter, List<DDSpan> trace, byte[] serializedTrace) {
            this.statsd.count("queue.accepted_size", (long)serializedTrace.length, new String[0]);
        }

        @Override
        public void onFailedSerialize(DDAgentWriter agentWriter, List<DDSpan> trace, Throwable optionalCause) {
        }

        @Override
        public void onSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
            this.onSendAttempt(agentWriter, representativeCount, sizeInBytes, response);
        }

        @Override
        public void onFailedSend(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
            this.onSendAttempt(agentWriter, representativeCount, sizeInBytes, response);
        }

        private void onSendAttempt(DDAgentWriter agentWriter, int representativeCount, int sizeInBytes, DDAgentApi.Response response) {
            this.statsd.incrementCounter("api.requests", new String[0]);
            this.statsd.recordGaugeValue("queue.length", (long)representativeCount, new String[0]);
            this.statsd.recordGaugeValue("queue.size", (long)sizeInBytes, new String[0]);
            if (response.exception() != null) {
                this.statsd.incrementCounter("api.errors", new String[0]);
            }
            if (response.status() != null) {
                this.statsd.incrementCounter("api.responses", new String[]{"status: " + response.status()});
            }
        }

        public String toString() {
            if (this.hostInfo == null) {
                return "StatsD";
            }
            return "StatsD { host=" + this.hostInfo + " }";
        }
    }
}

