/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslatorTwoArg;
import datadog.common.exec.DaemonThreadFactory;
import datadog.opentracing.DDSpan;
import datadog.trace.common.processor.TraceProcessor;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.ddagent.AbstractDisruptor;
import datadog.trace.common.writer.ddagent.BatchWritingDisruptor;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DisruptorEvent;
import datadog.trace.common.writer.ddagent.Monitor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceProcessingDisruptor
extends AbstractDisruptor<List<DDSpan>> {
    private static final Logger log = LoggerFactory.getLogger(TraceProcessingDisruptor.class);

    public TraceProcessingDisruptor(int disruptorSize, DDAgentApi api, BatchWritingDisruptor batchWritingDisruptor, Monitor monitor, DDAgentWriter writer) {
        super(disruptorSize, new TraceSerializingHandler(api, batchWritingDisruptor, monitor, writer));
    }

    @Override
    protected DaemonThreadFactory getThreadFactory() {
        return DaemonThreadFactory.TRACE_PROCESSOR;
    }

    @Override
    public boolean publish(List<DDSpan> data, int representativeCount) {
        return this.disruptor.getRingBuffer().tryPublishEvent((EventTranslatorTwoArg)this.dataTranslator, data, (Object)representativeCount);
    }

    public static class TraceSerializingHandler
    implements EventHandler<DisruptorEvent<List<DDSpan>>> {
        private final TraceProcessor processor = new TraceProcessor();
        private final DDAgentApi api;
        private final BatchWritingDisruptor batchWritingDisruptor;
        private final Monitor monitor;
        private final DDAgentWriter writer;

        public TraceSerializingHandler(DDAgentApi api, BatchWritingDisruptor batchWritingDisruptor, Monitor monitor, DDAgentWriter writer) {
            this.api = api;
            this.batchWritingDisruptor = batchWritingDisruptor;
            this.monitor = monitor;
            this.writer = writer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onEvent(DisruptorEvent<List<DDSpan>> event, long sequence, boolean endOfBatch) {
            try {
                if (event.data != null) {
                    try {
                        event.data = this.processor.onTraceComplete((List)event.data);
                        byte[] serializedTrace = this.api.serializeTrace((List)event.data);
                        this.batchWritingDisruptor.publish(serializedTrace, event.representativeCount);
                        this.monitor.onSerialize(this.writer, (List)event.data, serializedTrace);
                        event.representativeCount = 0;
                    }
                    catch (Throwable e) {
                        log.debug("Error while serializing trace", e);
                        this.monitor.onFailedSerialize(this.writer, (List)event.data, e);
                    }
                }
                if (event.flushLatch != null) {
                    if (this.batchWritingDisruptor.running) {
                        this.batchWritingDisruptor.flush(event.representativeCount, event.flushLatch);
                    }
                    if (!this.batchWritingDisruptor.running) {
                        event.flushLatch.countDown();
                    }
                }
            }
            finally {
                event.reset();
            }
        }
    }
}

