/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.TypeConverter;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.context.TraceScope;
import datadog.trace.core.CoreTracer;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import java.util.Objects;

class OTScopeManager
implements ScopeManager {
    private final TypeConverter converter;
    private final CoreTracer coreTracer;

    OTScopeManager(CoreTracer coreTracer, TypeConverter converter) {
        this.coreTracer = coreTracer;
        this.converter = converter;
    }

    public Scope activate(Span span) {
        return this.activate(span, false);
    }

    public Scope activate(Span span, boolean finishSpanOnClose) {
        AgentSpan agentSpan = this.converter.toAgentSpan(span);
        AgentScope agentScope = this.coreTracer.activateSpan(agentSpan, finishSpanOnClose);
        return this.converter.toScope(agentScope);
    }

    public Scope active() {
        return this.converter.toScope(this.coreTracer.activeScope());
    }

    public Span activeSpan() {
        return this.converter.toSpan(this.coreTracer.activeSpan());
    }

    static class OTTraceScope
    extends OTScope
    implements TraceScope {
        private final TraceScope delegate;

        OTTraceScope(TraceScope delegate, TypeConverter converter) {
            super((AgentScope)delegate, converter);
            this.delegate = delegate;
        }

        public TraceScope.Continuation capture() {
            return this.delegate.capture();
        }

        public boolean isAsyncPropagating() {
            return this.delegate.isAsyncPropagating();
        }

        public void setAsyncPropagation(boolean value) {
            this.delegate.setAsyncPropagation(value);
        }
    }

    static class OTScope
    implements Scope {
        private final AgentScope delegate;
        private final TypeConverter converter;

        OTScope(AgentScope delegate, TypeConverter converter) {
            this.delegate = delegate;
            this.converter = converter;
        }

        public void close() {
            this.delegate.close();
        }

        public Span span() {
            return this.converter.toSpan(this.delegate.span());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OTScope)) {
                return false;
            }
            OTScope otScope = (OTScope)o;
            return this.delegate.equals(otScope.delegate);
        }

        public int hashCode() {
            return Objects.hash(this.delegate);
        }
    }
}

