/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.CustomScopeManagerWrapper;
import datadog.opentracing.LogHandler;
import datadog.opentracing.OTExtractedContext;
import datadog.opentracing.OTGenericContext;
import datadog.opentracing.OTScopeManager;
import datadog.opentracing.OTSpan;
import datadog.opentracing.OTTagContext;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.TraceScope;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.TagContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.noop.NoopSpan;

class TypeConverter {
    private final LogHandler logHandler;

    public TypeConverter(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    public AgentSpan toAgentSpan(Span span) {
        if (span == null) {
            return null;
        }
        if (span instanceof OTSpan) {
            return ((OTSpan)span).getDelegate();
        }
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    public Span toSpan(AgentSpan agentSpan) {
        if (agentSpan == null) {
            return null;
        }
        if (agentSpan instanceof DDSpan) {
            return new OTSpan((DDSpan)agentSpan, this, this.logHandler);
        }
        return NoopSpan.INSTANCE;
    }

    public Scope toScope(Object scope) {
        if (scope == null) {
            return null;
        }
        if (scope instanceof CustomScopeManagerWrapper.CustomScopeManagerScope) {
            return ((CustomScopeManagerWrapper.CustomScopeManagerScope)scope).getDelegate();
        }
        if (scope instanceof TraceScope) {
            return new OTScopeManager.OTTraceScope((TraceScope)scope, this);
        }
        return new OTScopeManager.OTScope((AgentScope)scope, this);
    }

    public SpanContext toSpanContext(DDSpanContext context) {
        return new OTGenericContext(context);
    }

    public SpanContext toSpanContext(TagContext tagContext) {
        if (tagContext == null) {
            return null;
        }
        if (tagContext instanceof ExtractedContext) {
            return new OTExtractedContext((ExtractedContext)tagContext);
        }
        return new OTTagContext(tagContext);
    }

    public AgentSpan.Context toContext(SpanContext spanContext) {
        if (spanContext == null) {
            return null;
        }
        if (spanContext instanceof OTGenericContext) {
            return ((OTGenericContext)spanContext).getDelegate();
        }
        if (spanContext instanceof OTExtractedContext) {
            return ((OTExtractedContext)spanContext).getDelegate();
        }
        if (spanContext instanceof OTTagContext) {
            return ((OTTagContext)spanContext).getDelegate();
        }
        return AgentTracer.NoopContext.INSTANCE;
    }
}

