/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.api;

import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.context.TraceScope;
import java.util.concurrent.atomic.AtomicReference;

public class AgentTracer {
    private static final TracerAPI DEFAULT = new NoopTracerAPI();
    private static final AtomicReference<TracerAPI> provider = new AtomicReference<TracerAPI>(DEFAULT);

    public static AgentSpan startSpan(String spanName) {
        return AgentTracer.get().startSpan(spanName);
    }

    public static AgentSpan startSpan(String spanName, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, startTimeMicros);
    }

    public static AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
        return AgentTracer.get().startSpan(spanName, parent);
    }

    public static AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, parent, startTimeMicros);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span);
    }

    @Deprecated
    public static AgentScope activateSpan(AgentSpan span, boolean finishSpanOnClose) {
        return AgentTracer.get().activateSpan(span, finishSpanOnClose);
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    public static TraceScope activeScope() {
        return AgentTracer.get().activeScope();
    }

    public static AgentPropagation propagate() {
        return AgentTracer.get().propagate();
    }

    public static AgentSpan noopSpan() {
        return AgentTracer.get().noopSpan();
    }

    public static void registerIfAbsent(TracerAPI trace) {
        provider.compareAndSet(DEFAULT, trace);
    }

    public static TracerAPI get() {
        return provider.get();
    }

    private AgentTracer() {
    }

    public static class NoopContext
    implements AgentSpan.Context {
        public static final NoopContext INSTANCE = new NoopContext();
    }

    static class NoopContinuation
    implements TraceScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        public TraceScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        public void cancel() {
        }

        public void close() {
        }

        public void close(boolean closeContinuationScope) {
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public TraceScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> AgentSpan.Context extract(C carrier, AgentPropagation.Getter<C> getter) {
            return NoopContext.INSTANCE;
        }
    }

    public static class NoopAgentScope
    implements AgentScope,
    TraceScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        public TraceScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan instanceof NoopAgentSpan;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public void finish() {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(String spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(String spanName) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span) {
            return this.activateSpan(span);
        }

        @Override
        @Deprecated
        public AgentScope activateSpan(AgentSpan span, boolean finishSpanOnClose) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public TraceScope activeScope() {
            return null;
        }

        @Override
        public AgentPropagation propagate() {
            return NoopAgentPropagation.INSTANCE;
        }

        @Override
        public AgentSpan noopSpan() {
            return NoopAgentSpan.INSTANCE;
        }
    }

    public static interface TracerAPI {
        public AgentSpan startSpan(String var1);

        public AgentSpan startSpan(String var1, long var2);

        public AgentSpan startSpan(String var1, AgentSpan.Context var2);

        public AgentSpan startSpan(String var1, AgentSpan.Context var2, long var3);

        public AgentScope activateSpan(AgentSpan var1);

        @Deprecated
        public AgentScope activateSpan(AgentSpan var1, boolean var2);

        public AgentSpan activeSpan();

        public TraceScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();
    }
}

