/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.sampling;

import datadog.trace.common.sampling.RateSampler;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeterministicSampler
implements RateSampler {
    private static final Logger log = LoggerFactory.getLogger(DeterministicSampler.class);
    private static final BigInteger KNUTH_FACTOR = new BigInteger("1111111111111111111");
    private static final BigDecimal TRACE_ID_MAX_AS_BIG_DECIMAL = new BigDecimal(CoreTracer.TRACE_ID_MAX);
    private static final BigInteger MODULUS = new BigInteger("2").pow(64);
    private final BigInteger cutoff;
    private final double rate;

    public DeterministicSampler(double rate) {
        this.rate = rate;
        this.cutoff = new BigDecimal(rate).multiply(TRACE_ID_MAX_AS_BIG_DECIMAL).toBigInteger();
        log.debug("Initializing the RateSampler, sampleRate: {} %", (Object)(rate * 100.0));
    }

    @Override
    public boolean sample(DDSpan span) {
        boolean sampled = this.rate == 1.0 ? true : (this.rate == 0.0 ? false : span.getTraceId().multiply(KNUTH_FACTOR).mod(MODULUS).compareTo(this.cutoff) < 0);
        log.debug("{} - Span is sampled: {}", (Object)span, (Object)sampled);
        return sampled;
    }

    @Override
    public double getSampleRate() {
        return this.rate;
    }
}

