/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import datadog.trace.api.Config;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.BatchWritingDisruptor;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Monitor;
import datadog.trace.common.writer.ddagent.TraceProcessingDisruptor;
import datadog.trace.core.DDSpan;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DDAgentWriter.class);
    private static final int DISRUPTOR_BUFFER_SIZE = 1024;
    private final DDAgentApi api;
    private final TraceProcessingDisruptor traceProcessingDisruptor;
    private final BatchWritingDisruptor batchWritingDisruptor;
    private final AtomicInteger traceCount = new AtomicInteger(0);
    public final Monitor monitor;

    @Deprecated
    public DDAgentWriter() {
        this(new DDAgentApi("localhost", 8126, Config.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET), new Monitor.Noop());
    }

    @Deprecated
    public DDAgentWriter(DDAgentApi api, Monitor monitor) {
        this.api = api;
        this.monitor = monitor;
        this.batchWritingDisruptor = new BatchWritingDisruptor(1024, 1, api, monitor, this);
        this.traceProcessingDisruptor = new TraceProcessingDisruptor(1024, api, this.batchWritingDisruptor, monitor, this);
    }

    private DDAgentWriter(DDAgentApi agentApi, String agentHost, int traceAgentPort, String unixDomainSocket, int traceBufferSize, Monitor monitor, int flushFrequencySeconds) {
        this.api = agentApi != null ? agentApi : new DDAgentApi(agentHost, traceAgentPort, unixDomainSocket);
        this.monitor = monitor;
        this.batchWritingDisruptor = new BatchWritingDisruptor(traceBufferSize, flushFrequencySeconds, this.api, monitor, this);
        this.traceProcessingDisruptor = new TraceProcessingDisruptor(traceBufferSize, this.api, this.batchWritingDisruptor, monitor, this);
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        this.api.addResponseListener(listener);
    }

    public final long getDisruptorCapacity() {
        return this.traceProcessingDisruptor.getDisruptorCapacity();
    }

    public final long getDisruptorUtilizedCapacity() {
        return this.getDisruptorCapacity() - this.getDisruptorRemainingCapacity();
    }

    public final long getDisruptorRemainingCapacity() {
        return this.traceProcessingDisruptor.getDisruptorRemainingCapacity();
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (this.traceProcessingDisruptor.running) {
            int representativeCount = trace.isEmpty() || !trace.get(0).isRootSpan() ? 1 : this.traceCount.getAndSet(0) + 1;
            boolean published = this.traceProcessingDisruptor.publish(trace, representativeCount);
            if (published) {
                this.monitor.onPublish(this, trace);
            } else {
                this.traceCount.addAndGet(representativeCount);
                log.debug("Trace written to overfilled buffer. Counted but dropping trace: {}", trace);
                this.monitor.onFailedPublish(this, trace);
            }
        } else {
            log.debug("Trace written after shutdown. Ignoring trace: {}", trace);
            this.monitor.onFailedPublish(this, trace);
        }
    }

    public boolean flush() {
        return this.traceProcessingDisruptor.flush(this.traceCount.getAndSet(0));
    }

    @Override
    public void incrementTraceCount() {
        this.traceCount.incrementAndGet();
    }

    public DDAgentApi getApi() {
        return this.api;
    }

    @Override
    public void start() {
        this.batchWritingDisruptor.start();
        this.traceProcessingDisruptor.start();
        this.monitor.onStart(this);
    }

    @Override
    public void close() {
        boolean flushSuccess = this.traceProcessingDisruptor.flush(this.traceCount.getAndSet(0));
        try {
            this.traceProcessingDisruptor.close();
        }
        finally {
            this.batchWritingDisruptor.close();
        }
        this.monitor.onShutdown(this, flushSuccess);
    }

    public String toString() {
        String str = "DDAgentWriter { api=" + this.api;
        if (!(this.monitor instanceof Monitor.Noop)) {
            str = str + ", monitor=" + this.monitor;
        }
        str = str + " }";
        return str;
    }

    public static DDAgentWriterBuilder builder() {
        return new DDAgentWriterBuilder();
    }

    public static class DDAgentWriterBuilder {
        private DDAgentApi agentApi;
        String agentHost = "localhost";
        int traceAgentPort = 8126;
        String unixDomainSocket = Config.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
        int traceBufferSize = 1024;
        Monitor monitor = new Monitor.Noop();
        int flushFrequencySeconds = 1;

        DDAgentWriterBuilder() {
        }

        public DDAgentWriterBuilder agentApi(DDAgentApi agentApi) {
            this.agentApi = agentApi;
            return this;
        }

        public DDAgentWriterBuilder agentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public DDAgentWriterBuilder traceAgentPort(int traceAgentPort) {
            this.traceAgentPort = traceAgentPort;
            return this;
        }

        public DDAgentWriterBuilder unixDomainSocket(String unixDomainSocket) {
            this.unixDomainSocket = unixDomainSocket;
            return this;
        }

        public DDAgentWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDAgentWriterBuilder monitor(Monitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public DDAgentWriterBuilder flushFrequencySeconds(int flushFrequencySeconds) {
            this.flushFrequencySeconds = flushFrequencySeconds;
            return this;
        }

        public DDAgentWriter build() {
            return new DDAgentWriter(this.agentApi, this.agentHost, this.traceAgentPort, this.unixDomainSocket, this.traceBufferSize, this.monitor, this.flushFrequencySeconds);
        }

        public String toString() {
            return "DDAgentWriter.DDAgentWriterBuilder(agentApi=" + this.agentApi + ", agentHost=" + this.agentHost + ", traceAgentPort=" + this.traceAgentPort + ", unixDomainSocket=" + this.unixDomainSocket + ", traceBufferSize=" + this.traceBufferSize + ", monitor=" + this.monitor + ", flushFrequencySeconds=" + this.flushFrequencySeconds + ")";
        }
    }
}

