/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.common.exec.CommonTaskExecutor;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.unixdomainsockets.UnixDomainSocketFactory;
import datadog.trace.core.ContainerInfo;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDTraceCoreInfo;
import datadog.trace.core.serialization.MsgpackFormatWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.buffer.ArrayBufferOutput;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi {
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final int HTTP_TIMEOUT = 1;
    private static final String TRACES_ENDPOINT_V3 = "v0.3/traces";
    private static final String TRACES_ENDPOINT_V4 = "v0.4/traces";
    private static final long MILLISECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toMillis(5L);
    private static final MessagePack.PackerConfig MESSAGE_PACKER_CONFIG = MessagePack.DEFAULT_PACKER_CONFIG.withSmallStringOptimizationThreshold(16);
    private final List<DDAgentResponseListener> responseListeners = new ArrayList<DDAgentResponseListener>();
    private volatile long nextAllowedLogTime = 0L;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Double.class})}));
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private final String host;
    private final int port;
    private final String unixDomainSocketPath;
    private OkHttpClient httpClient;
    private HttpUrl tracesUrl;
    private static final byte[] EMPTY_LIST = new byte[]{-112};

    public DDAgentApi(String host, int port, String unixDomainSocketPath) {
        this.host = host;
        this.port = port;
        this.unixDomainSocketPath = unixDomainSocketPath;
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    Response sendTraces(List<List<DDSpan>> traces) {
        ArrayList<byte[]> serializedTraces = new ArrayList<byte[]>(traces.size());
        int sizeInBytes = 0;
        for (List<DDSpan> trace : traces) {
            try {
                byte[] serializedTrace = this.serializeTrace(trace);
                sizeInBytes += serializedTrace.length;
                serializedTraces.add(serializedTrace);
            }
            catch (IOException e) {
                log.warn("Error serializing trace", (Throwable)e);
            }
        }
        return this.sendSerializedTraces(serializedTraces.size(), sizeInBytes, serializedTraces);
    }

    byte[] serializeTrace(List<DDSpan> trace) throws IOException {
        ArrayBufferOutput output = new ArrayBufferOutput();
        MessagePacker packer = MESSAGE_PACKER_CONFIG.newPacker((MessageBufferOutput)output);
        MsgpackFormatWriter.MSGPACK_WRITER.writeTrace(trace, packer);
        packer.flush();
        return output.toByteArray();
    }

    /*
     * Loose catch block
     */
    Response sendSerializedTraces(int representativeCount, final Integer sizeInBytes, final List<byte[]> traces) {
        Object parsedResponse;
        String responseString;
        Throwable throwable;
        okhttp3.Response response;
        block36: {
            block37: {
                block33: {
                    Response response2;
                    block34: {
                        block35: {
                            if (this.httpClient == null) {
                                this.detectEndpointAndBuildClient();
                            }
                            RequestBody body = new RequestBody(){

                                public MediaType contentType() {
                                    return MSGPACK;
                                }

                                public long contentLength() {
                                    int traceCount = traces.size();
                                    if (traceCount < 16) {
                                        return sizeInBytes + 1;
                                    }
                                    if (traceCount < 65536) {
                                        return sizeInBytes + 3;
                                    }
                                    return sizeInBytes + 5;
                                }

                                public void writeTo(BufferedSink sink) throws IOException {
                                    OutputStream out = sink.outputStream();
                                    MessagePacker packer = MessagePack.newDefaultPacker((OutputStream)out);
                                    packer.packArrayHeader(traces.size());
                                    for (byte[] trace : traces) {
                                        packer.writePayload(trace);
                                    }
                                    packer.close();
                                    out.close();
                                }
                            };
                            Request request = DDAgentApi.prepareRequest(this.tracesUrl).addHeader(X_DATADOG_TRACE_COUNT, String.valueOf(representativeCount)).put(body).build();
                            response = this.httpClient.newCall(request).execute();
                            throwable = null;
                            if (response.code() == 200) break block33;
                            if (log.isDebugEnabled()) {
                                log.debug("Error while sending {} of {} traces to the DD agent. Status: {}, Response: {}, Body: {}", new Object[]{traces.size(), representativeCount, response.code(), response.message(), response.body().string()});
                            } else if (this.nextAllowedLogTime < System.currentTimeMillis()) {
                                this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
                                log.warn("Error while sending {} of {} traces to the DD agent. Status: {} {} (going silent for {} minutes)", new Object[]{traces.size(), representativeCount, response.code(), response.message(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
                            }
                            response2 = Response.failed(response.code());
                            if (response == null) break block34;
                            if (throwable == null) break block35;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block34;
                        }
                        response.close();
                    }
                    return response2;
                }
                log.debug("Successfully sent {} of {} traces to the DD agent.", (Object)traces.size(), (Object)representativeCount);
                responseString = response.body().string().trim();
                if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                    parsedResponse = (Map)RESPONSE_ADAPTER.fromJson(responseString);
                    String endpoint = this.tracesUrl.toString();
                    for (DDAgentResponseListener listener : this.responseListeners) {
                        listener.onResponse(endpoint, (Map<String, Map<String, Number>>)parsedResponse);
                    }
                }
                parsedResponse = Response.success(response.code());
                if (response == null) break block36;
                if (throwable == null) break block37;
                try {
                    response.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                break block36;
            }
            response.close();
        }
        return parsedResponse;
        {
            catch (IOException e) {
                Response response3;
                block38: {
                    block39: {
                        log.debug("Failed to parse DD agent response: " + responseString, (Throwable)e);
                        response3 = Response.success(response.code(), e);
                        if (response == null) break block38;
                        if (throwable == null) break block39;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        break block38;
                    }
                    response.close();
                }
                return response3;
                {
                    catch (Throwable throwable5) {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (IOException e2) {
                            if (log.isDebugEnabled()) {
                                log.debug("Error while sending " + traces.size() + " of " + representativeCount + " traces to the DD agent.", (Throwable)e2);
                            } else if (this.nextAllowedLogTime < System.currentTimeMillis()) {
                                this.nextAllowedLogTime = System.currentTimeMillis() + MILLISECONDS_BETWEEN_ERROR_LOG;
                                log.warn("Error while sending {} of {} traces to the DD agent. {}: {} (going silent for {} minutes)", new Object[]{traces.size(), representativeCount, e2.getClass().getName(), e2.getMessage(), TimeUnit.MILLISECONDS.toMinutes(MILLISECONDS_BETWEEN_ERROR_LOG)});
                            }
                            return Response.failed(e2);
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean endpointAvailable(HttpUrl url, String unixDomainSocketPath, boolean retry) {
        try {
            OkHttpClient client = DDAgentApi.buildHttpClient(unixDomainSocketPath);
            RequestBody body = RequestBody.create((MediaType)MSGPACK, (byte[])EMPTY_LIST);
            Request request = DDAgentApi.prepareRequest(url).put(body).build();
            try (okhttp3.Response response = client.newCall(request).execute();){
                boolean bl = response.code() == 200;
                return bl;
            }
        }
        catch (IOException e) {
            if (!retry) return false;
            return DDAgentApi.endpointAvailable(url, unixDomainSocketPath, false);
        }
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder = builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        return builder.connectTimeout(1L, TimeUnit.SECONDS).writeTimeout(1L, TimeUnit.SECONDS).readTimeout(1L, TimeUnit.SECONDS).dispatcher(new Dispatcher((ExecutorService)CommonTaskExecutor.INSTANCE)).build();
    }

    private static HttpUrl getUrl(String host, int port, String endPoint) {
        return new HttpUrl.Builder().scheme("http").host(host).port(port).addEncodedPathSegments(endPoint).build();
    }

    private static Request.Builder prepareRequest(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, DDTraceCoreInfo.JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, DDTraceCoreInfo.JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, DDTraceCoreInfo.JAVA_VM_VENDOR).addHeader(DATADOG_META_TRACER_VERSION, DDTraceCoreInfo.VERSION);
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId == null) {
            return builder;
        }
        return builder.addHeader(DATADOG_CONTAINER_ID, containerId);
    }

    private synchronized void detectEndpointAndBuildClient() {
        if (this.httpClient == null) {
            HttpUrl v4Url = DDAgentApi.getUrl(this.host, this.port, TRACES_ENDPOINT_V4);
            if (DDAgentApi.endpointAvailable(v4Url, this.unixDomainSocketPath, true)) {
                this.tracesUrl = v4Url;
            } else {
                log.debug("API v0.4 endpoints not available. Downgrading to v0.3");
                this.tracesUrl = DDAgentApi.getUrl(this.host, this.port, TRACES_ENDPOINT_V3);
            }
            this.httpClient = DDAgentApi.buildHttpClient(this.unixDomainSocketPath);
        }
    }

    public String toString() {
        return "DDApi { tracesUrl=" + this.tracesUrl + " }";
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;

        public static final Response success(int status) {
            return new Response(true, status, null);
        }

        public static final Response success(int status, Throwable exception) {
            return new Response(true, status, exception);
        }

        public static final Response failed(int status) {
            return new Response(false, status, null);
        }

        public static final Response failed(Throwable exception) {
            return new Response(false, null, exception);
        }

        private Response(boolean success, Integer status, Throwable exception) {
            this.success = success;
            this.status = status;
            this.exception = exception;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }
    }
}

