/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.DDComponents;
import datadog.trace.bootstrap.instrumentation.api.Tags;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class StringTables {
    public static final String SERVICE = "service";
    public static final String NAME = "name";
    public static final String RESOURCE = "resource";
    public static final String TRACE_ID = "trace_id";
    public static final String SPAN_ID = "span_id";
    public static final String PARENT_ID = "parent_id";
    public static final String START = "start";
    public static final String DURATION = "duration";
    public static final String TYPE = "type";
    public static final String ERROR = "error";
    public static final String METRICS = "metrics";
    public static final String META = "meta";
    private static final Map<String, byte[]> UTF8_INTERN_TABLE = new HashMap<String, byte[]>(256);

    public static byte[] getBytesUTF8(String value) {
        byte[] bytes = UTF8_INTERN_TABLE.get(value);
        return null == bytes ? value.getBytes(StandardCharsets.UTF_8) : bytes;
    }

    private static void internConstantsUTF8(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                StringTables.intern(UTF8_INTERN_TABLE, (String)field.get(null), StandardCharsets.UTF_8);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void intern(Map<String, byte[]> table, String value, Charset encoding) {
        table.put(value, value.getBytes(encoding));
    }

    static {
        StringTables.internConstantsUTF8(StringTables.class);
        StringTables.internConstantsUTF8(Tags.class);
        StringTables.internConstantsUTF8(DDSpanTypes.class);
        StringTables.internConstantsUTF8(DDComponents.class);
    }
}

