/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.decorators;

import datadog.trace.api.Config;
import datadog.trace.core.decorators.AbstractDecorator;
import datadog.trace.core.decorators.DBTypeDecorator;
import datadog.trace.core.decorators.ForceManualDropDecorator;
import datadog.trace.core.decorators.ForceManualKeepDecorator;
import datadog.trace.core.decorators.PeerServiceDecorator;
import datadog.trace.core.decorators.ServiceNameDecorator;
import datadog.trace.core.decorators.ServletContextDecorator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDDecoratorsFactory {
    private static final Logger log = LoggerFactory.getLogger(DDDecoratorsFactory.class);

    public static List<AbstractDecorator> createBuiltinDecorators() {
        ArrayList<AbstractDecorator> decorators = new ArrayList<AbstractDecorator>();
        for (AbstractDecorator decorator : Arrays.asList(new DBTypeDecorator(), new ForceManualDropDecorator(), new ForceManualKeepDecorator(), new PeerServiceDecorator(), new ServiceNameDecorator(), new ServiceNameDecorator("service", false), new ServletContextDecorator())) {
            if (Config.get().isRuleEnabled(decorator.getClass().getSimpleName())) {
                decorators.add(decorator);
                continue;
            }
            log.debug("{} disabled", (Object)decorator.getClass().getSimpleName());
        }
        for (String splitByTag : Config.get().getSplitByTags()) {
            decorators.add(new ServiceNameDecorator(splitByTag, true));
        }
        return decorators;
    }
}

