/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor;

import datadog.trace.api.Config;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.rule.AnalyticsSampleRateRule;
import datadog.trace.core.processor.rule.DBStatementRule;
import datadog.trace.core.processor.rule.ErrorRule;
import datadog.trace.core.processor.rule.HttpStatusErrorRule;
import datadog.trace.core.processor.rule.ResourceNameRule;
import datadog.trace.core.processor.rule.SpanTypeRule;
import datadog.trace.core.processor.rule.Status404Rule;
import datadog.trace.core.processor.rule.URLAsResourceNameRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceProcessor {
    private static final Logger log = LoggerFactory.getLogger(TraceProcessor.class);
    final Rule[] DEFAULT_RULES = new Rule[]{new DBStatementRule(), new ResourceNameRule(), new SpanTypeRule(), new ErrorRule(), new HttpStatusErrorRule(), new URLAsResourceNameRule(), new Status404Rule(), new AnalyticsSampleRateRule()};
    private final List<Rule> rules = new ArrayList<Rule>(this.DEFAULT_RULES.length);

    public TraceProcessor() {
        for (Rule rule : this.DEFAULT_RULES) {
            if (!TraceProcessor.isEnabled(rule)) continue;
            this.rules.add(rule);
        }
    }

    private static boolean isEnabled(Rule rule) {
        boolean enabled = Config.get().isRuleEnabled(rule.getClass().getSimpleName());
        for (String alias : rule.aliases()) {
            enabled &= Config.get().isRuleEnabled(alias);
        }
        if (!enabled) {
            log.debug("{} disabled", (Object)rule.getClass().getSimpleName());
        }
        return enabled;
    }

    public List<DDSpan> onTraceComplete(List<DDSpan> trace) {
        for (DDSpan span : trace) {
            this.applyRules(trace, span);
        }
        return trace;
    }

    private void applyRules(Collection<DDSpan> trace, DDSpan span) {
        Map<String, Object> tags = span.getTags();
        for (Rule rule : this.rules) {
            rule.processSpan(span, tags, trace);
        }
    }

    public static interface Rule {
        public String[] aliases();

        public void processSpan(DDSpan var1, Map<String, Object> var2, Collection<DDSpan> var3);
    }
}

