/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor.rule;

import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.util.Collection;
import java.util.Map;

public class DBStatementRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[]{"DBStatementAsResourceName"};
    }

    @Override
    public void processSpan(DDSpan span, Map<String, Object> tags, Collection<DDSpan> trace) {
        Object dbStatementValue = tags.get("db.statement");
        if (dbStatementValue instanceof String) {
            if (tags.containsKey("component") && "java-mongo".equals(tags.get("component"))) {
                return;
            }
            String statement = (String)dbStatementValue;
            if (!statement.isEmpty()) {
                span.setResourceName(statement);
            }
        }
        span.removeTag("db.statement");
    }
}

