/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContext;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HaystackHttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HaystackHttpCodec.class);
    private static final String OT_BAGGAGE_PREFIX = "Baggage-";
    private static final String TRACE_ID_KEY = "Trace-ID";
    private static final String SPAN_ID_KEY = "Span-ID";
    private static final String PARENT_ID_KEY = "Parent_ID";

    private HaystackHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
            }
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.Getter<C> getter) {
            try {
                Map<String, String> baggage = Collections.emptyMap();
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                boolean samplingPriority = true;
                String origin = null;
                for (String uncasedKey : getter.keys(carrier)) {
                    String key = uncasedKey.toLowerCase();
                    String value = HttpCodec.firstHeaderValue(getter.get(carrier, uncasedKey));
                    if (value == null) continue;
                    if (HaystackHttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        traceId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (HaystackHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (key.startsWith(HaystackHttpCodec.OT_BAGGAGE_PREFIX.toLowerCase())) {
                        if (baggage.isEmpty()) {
                            baggage = new HashMap<String, String>();
                        }
                        baggage.put(key.replace(HaystackHttpCodec.OT_BAGGAGE_PREFIX.toLowerCase(), ""), HttpCodec.decode(value));
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, 1, origin, baggage, tags);
                    context.lockSamplingPriority();
                    log.debug("{} - Parent context extracted", (Object)context.getTraceId());
                    return context;
                }
                if (origin != null || !tags.isEmpty()) {
                    log.debug("Tags context extracted");
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException e) {
                log.debug("Exception when extracting context", (Throwable)e);
            }
            return null;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            setter.set(carrier, HaystackHttpCodec.TRACE_ID_KEY, context.getTraceId().toString());
            setter.set(carrier, HaystackHttpCodec.SPAN_ID_KEY, context.getSpanId().toString());
            setter.set(carrier, HaystackHttpCodec.PARENT_ID_KEY, context.getParentId().toString());
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                setter.set(carrier, HaystackHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            log.debug("{} - Haystack parent context injected", (Object)context.getTraceId());
        }
    }
}

