/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.DDSpan;
import datadog.trace.core.jfr.DDScopeEventFactory;
import datadog.trace.core.scopemanager.ContinuableScope;
import datadog.trace.core.scopemanager.DDScope;
import datadog.trace.core.scopemanager.DDScopeManager;
import datadog.trace.core.scopemanager.SimpleScope;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextualScopeManager
implements DDScopeManager {
    private static final Logger log = LoggerFactory.getLogger(ContextualScopeManager.class);
    static final ThreadLocal<DDScope> tlsScope = new ThreadLocal();
    final List<ScopeListener> scopeListeners = new CopyOnWriteArrayList<ScopeListener>();
    private final int depthLimit;
    private final DDScopeEventFactory scopeEventFactory;

    public ContextualScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory) {
        this.depthLimit = depthLimit;
        this.scopeEventFactory = scopeEventFactory;
    }

    @Override
    public AgentScope activate(AgentSpan span) {
        return this.activate(span, false);
    }

    @Override
    @Deprecated
    public AgentScope activate(AgentSpan span, boolean finishOnClose) {
        int currentDepth;
        DDScope active = tlsScope.get();
        if (active != null && active.span().equals(span)) {
            return active.incrementReferences();
        }
        int n = currentDepth = active == null ? 0 : active.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        if (span instanceof DDSpan) {
            return new ContinuableScope(this, (DDSpan)span, finishOnClose, this.scopeEventFactory);
        }
        return new SimpleScope(this, span, finishOnClose);
    }

    @Override
    public TraceScope active() {
        return tlsScope.get();
    }

    @Override
    public AgentSpan activeSpan() {
        DDScope active = tlsScope.get();
        return active == null ? null : active.span();
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeListeners.add(listener);
    }
}

