/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.scopemanager.ContextualScopeManager;
import datadog.trace.core.scopemanager.DDScope;
import java.util.concurrent.atomic.AtomicInteger;

public class SimpleScope
implements DDScope {
    private final ContextualScopeManager scopeManager;
    private final AgentSpan spanUnderScope;
    private final boolean finishOnClose;
    private final DDScope toRestore;
    private final int depth;
    private final AtomicInteger referenceCount = new AtomicInteger(1);

    public SimpleScope(ContextualScopeManager scopeManager, AgentSpan spanUnderScope, boolean finishOnClose) {
        assert (spanUnderScope != null) : "span must not be null";
        this.scopeManager = scopeManager;
        this.spanUnderScope = spanUnderScope;
        this.finishOnClose = finishOnClose;
        this.toRestore = ContextualScopeManager.tlsScope.get();
        ContextualScopeManager.tlsScope.set(this);
        this.depth = this.toRestore == null ? 0 : this.toRestore.depth() + 1;
        for (ScopeListener listener : scopeManager.scopeListeners) {
            listener.afterScopeActivated();
        }
    }

    @Override
    public void close() {
        if (this.referenceCount.decrementAndGet() > 0) {
            return;
        }
        if (this.finishOnClose) {
            this.spanUnderScope.finish();
        }
        for (ScopeListener listener : this.scopeManager.scopeListeners) {
            listener.afterScopeClosed();
        }
        if (ContextualScopeManager.tlsScope.get() == this) {
            ContextualScopeManager.tlsScope.set(this.toRestore);
            if (this.toRestore != null) {
                for (ScopeListener listener : this.scopeManager.scopeListeners) {
                    listener.afterScopeActivated();
                }
            }
        }
    }

    @Override
    public AgentSpan span() {
        return this.spanUnderScope;
    }

    public boolean isAsyncPropagating() {
        return false;
    }

    public TraceScope.Continuation capture() {
        return null;
    }

    @Override
    public void setAsyncPropagation(boolean value) {
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public DDScope incrementReferences() {
        this.referenceCount.incrementAndGet();
        return this;
    }
}

