/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.core.DDSpan;
import datadog.trace.core.serialization.FormatWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;

public class JsonFormatWriter
extends FormatWriter<JsonWriter> {
    private static final Moshi MOSHI = new Moshi.Builder().add(DDSpanAdapter.FACTORY).build();
    public static final JsonAdapter<List<DDSpan>> TRACE_ADAPTER = MOSHI.adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{DDSpan.class}));
    public static final JsonAdapter<DDSpan> SPAN_ADAPTER = MOSHI.adapter(DDSpan.class);
    public static JsonFormatWriter JSON_WRITER = new JsonFormatWriter();

    @Override
    public void writeKey(String key, JsonWriter destination) throws IOException {
        destination.name(key);
    }

    @Override
    public void writeListHeader(int size, JsonWriter destination) throws IOException {
        destination.beginArray();
    }

    @Override
    public void writeListFooter(JsonWriter destination) throws IOException {
        destination.endArray();
    }

    @Override
    public void writeMapHeader(int size, JsonWriter destination) throws IOException {
        destination.beginObject();
    }

    @Override
    public void writeMapFooter(JsonWriter destination) throws IOException {
        destination.endObject();
    }

    @Override
    public void writeString(String key, String value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value(value);
    }

    @Override
    public void writeShort(String key, short value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value((long)value);
    }

    @Override
    public void writeByte(String key, byte value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value((long)value);
    }

    @Override
    public void writeInt(String key, int value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value((long)value);
    }

    @Override
    public void writeLong(String key, long value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value(value);
    }

    @Override
    public void writeFloat(String key, float value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value((double)value);
    }

    @Override
    public void writeDouble(String key, double value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value(value);
    }

    @Override
    public void writeBigInteger(String key, BigInteger value, JsonWriter destination) throws IOException {
        destination.name(key);
        destination.value((Number)value);
    }

    static class DDSpanAdapter
    extends JsonAdapter<DDSpan> {
        public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Class rawType = Types.getRawType((Type)type);
                if (rawType.isAssignableFrom(DDSpan.class)) {
                    return new DDSpanAdapter();
                }
                return null;
            }
        };

        DDSpanAdapter() {
        }

        public DDSpan fromJson(JsonReader reader) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void toJson(JsonWriter writer, DDSpan value) throws IOException {
            JSON_WRITER.writeDDSpan(value, writer);
        }
    }
}

