/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import datadog.trace.core.StringTables;
import datadog.trace.core.serialization.FormatWriter;
import java.io.IOException;
import java.math.BigInteger;
import org.msgpack.core.MessagePacker;

public class MsgpackFormatWriter
extends FormatWriter<MessagePacker> {
    public static MsgpackFormatWriter MSGPACK_WRITER = new MsgpackFormatWriter();

    @Override
    public void writeKey(String key, MessagePacker destination) throws IOException {
        destination.packString(key);
    }

    @Override
    public void writeListHeader(int size, MessagePacker destination) throws IOException {
        destination.packArrayHeader(size);
    }

    @Override
    public void writeListFooter(MessagePacker destination) {
    }

    @Override
    public void writeMapHeader(int size, MessagePacker destination) throws IOException {
        destination.packMapHeader(size);
    }

    @Override
    public void writeMapFooter(MessagePacker destination) {
    }

    @Override
    public void writeString(String key, String value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        if (value == null) {
            destination.packNil();
        } else {
            destination.packString(value);
        }
    }

    @Override
    public void writeTag(String key, String value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        if (value == null) {
            destination.packNil();
        } else {
            MsgpackFormatWriter.writeStringUTF8(value, destination);
        }
    }

    @Override
    public void writeShort(String key, short value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packShort(value);
    }

    @Override
    public void writeByte(String key, byte value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packByte(value);
    }

    @Override
    public void writeInt(String key, int value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packInt(value);
    }

    @Override
    public void writeLong(String key, long value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packLong(value);
    }

    @Override
    public void writeFloat(String key, float value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packFloat(value);
    }

    @Override
    public void writeDouble(String key, double value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        destination.packDouble(value);
    }

    @Override
    public void writeBigInteger(String key, BigInteger value, MessagePacker destination) throws IOException {
        MsgpackFormatWriter.writeStringUTF8(key, destination);
        if (value == null) {
            destination.packNil();
        } else {
            destination.packBigInteger(value);
        }
    }

    private static void writeStringUTF8(String value, MessagePacker destination) throws IOException {
        if (value.length() < 256) {
            byte[] utf8 = StringTables.getBytesUTF8(value);
            destination.packRawStringHeader(utf8.length);
            destination.addPayload(utf8);
        } else {
            destination.packString(value);
        }
    }
}

