/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.Tracer;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.common.sampling.PrioritySampler;
import datadog.trace.common.sampling.Sampler;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.DDSpan;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.StringCachingBigInteger;
import datadog.trace.core.decorators.AbstractDecorator;
import datadog.trace.core.decorators.DDDecoratorsFactory;
import datadog.trace.core.jfr.DDNoopScopeEventFactory;
import datadog.trace.core.jfr.DDScopeEventFactory;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContext;
import datadog.trace.core.scopemanager.ContinuableScopeManager;
import datadog.trace.core.scopemanager.DDScopeManager;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements Closeable,
Tracer,
AgentTracer.TracerAPI,
AgentPropagation {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    public static final BigInteger TRACE_ID_MIN = BigInteger.ZERO;
    final String serviceName;
    final Writer writer;
    final Sampler sampler;
    final DDScopeManager scopeManager;
    private final Map<String, String> localRootSpanTags;
    private final Map<String, String> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final Thread shutdownCallback;
    private final Map<String, List<AbstractDecorator>> spanContextDecorators = new ConcurrentHashMap<String, List<AbstractDecorator>>();
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;

    @Override
    public TraceScope.Continuation capture() {
        TraceScope activeScope = this.activeScope();
        return activeScope == null ? null : activeScope.capture();
    }

    private CoreTracer(Config config, String serviceName, Writer writer, Sampler sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, DDScopeManager scopeManager, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.serviceName = serviceName;
        this.writer = writer == null ? Writer.Builder.forConfig(config) : writer;
        this.sampler = sampler;
        this.injector = injector;
        this.extractor = extractor;
        this.scopeManager = scopeManager;
        this.localRootSpanTags = localRootSpanTags;
        this.defaultSpanTags = defaultSpanTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        this.writer.start();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.writer instanceof DDAgentWriter && sampler instanceof DDAgentResponseListener) {
            ((DDAgentWriter)this.writer).addResponseListener((DDAgentResponseListener)((Object)this.sampler));
        }
        log.info("New instance: {}", (Object)this);
        List<AbstractDecorator> decorators = DDDecoratorsFactory.createBuiltinDecorators();
        for (AbstractDecorator decorator : decorators) {
            this.addDecorator(decorator);
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        PendingTrace.initialize();
    }

    public void finalize() {
        try {
            this.shutdownCallback.run();
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            log.error("Error while finalizing DDTracer.", (Throwable)e);
        }
    }

    public List<AbstractDecorator> getSpanContextDecorators(String tag) {
        return this.spanContextDecorators.get(tag);
    }

    public void addDecorator(AbstractDecorator decorator) {
        List<AbstractDecorator> list = this.spanContextDecorators.get(decorator.getMatchingTag());
        if (list == null) {
            list = new ArrayList<AbstractDecorator>();
        }
        list.add(decorator);
        this.spanContextDecorators.put(decorator.getMatchingTag(), list);
        log.debug("Decorator added: '{}' -> {}", (Object)decorator.getMatchingTag(), (Object)decorator.getClass().getName());
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: " + classLoader, (Throwable)e);
        }
    }

    public CoreSpanBuilder buildSpan(String operationName) {
        return new CoreSpanBuilder(operationName);
    }

    @Override
    public AgentSpan startSpan(String spanName) {
        return this.buildSpan(spanName).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, long startTimeMicros) {
        return this.buildSpan(spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, AgentSpan.Context parent) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(String spanName, AgentSpan.Context parent, long startTimeMicros) {
        return this.buildSpan(spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span);
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public TraceScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter);
    }

    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        DDSpan rootSpan = ddSpanContext.getTrace().getRootSpan();
        this.setSamplingPriorityIfNecessary(rootSpan);
        this.injector.inject(ddSpanContext, carrier, setter);
    }

    @Override
    public <C> TagContext extract(C carrier, AgentPropagation.Getter<C> getter) {
        return this.extractor.extract(carrier, getter);
    }

    void write(Collection<DDSpan> trace) {
        ArrayList<DDSpan> writtenTrace;
        if (trace.isEmpty()) {
            return;
        }
        if (this.interceptors.isEmpty()) {
            writtenTrace = new ArrayList<DDSpan>(trace);
        } else {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
            }
            writtenTrace = new ArrayList(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        if (!writtenTrace.isEmpty()) {
            DDSpan spanToSample;
            DDSpan rootSpan = writtenTrace.get(0).getLocalRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            DDSpan dDSpan = spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
            if (this.sampler.sample(spanToSample)) {
                this.writer.write(writtenTrace);
            } else {
                this.incrementTraceCount();
            }
        }
    }

    void setSamplingPriorityIfNecessary(DDSpan rootSpan) {
        if (this.sampler instanceof PrioritySampler && rootSpan != null && rootSpan.context().getSamplingPriority() == Integer.MIN_VALUE) {
            ((PrioritySampler)((Object)this.sampler)).setSamplingPriority(rootSpan);
        }
    }

    void incrementTraceCount() {
        this.writer.incrementTraceCount();
    }

    public String getTraceId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getTraceId().toString();
        }
        return "0";
    }

    public String getSpanId() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId().toString();
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void close() {
        PendingTrace.close();
        this.writer.close();
    }

    public String toString() {
        return "DDTracer-" + Integer.toHexString(this.hashCode()) + "{ serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", defaultSpanTags=" + this.defaultSpanTags + '}';
    }

    private static DDScopeEventFactory createScopeEventFactory() {
        try {
            return (DDScopeEventFactory)Class.forName("datadog.trace.core.jfr.openjdk.ScopeEventFactory").newInstance();
        }
        catch (ClassFormatError | NoClassDefFoundError | ReflectiveOperationException e) {
            log.debug("Profiling of ScopeEvents is not available");
            return new DDNoopScopeEventFactory();
        }
    }

    public static CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super("dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder {
        private final String operationName;
        private final Map<String, Object> tags;
        private long timestampMicro;
        private Object parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private String spanType;
        private boolean ignoreScope;

        public CoreSpanBuilder(String operationName) {
            this.tags = new LinkedHashMap<String, Object>(CoreTracer.this.defaultSpanTags);
            this.ignoreScope = false;
            this.operationName = operationName;
        }

        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            return DDSpan.create(this.timestampMicro, this.buildSpanContext());
        }

        public AgentSpan start() {
            DDSpan span = this.buildSpan();
            log.debug("Starting a new span: {}", (Object)span);
            return span;
        }

        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        public CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        public CoreSpanBuilder withSpanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        public CoreSpanBuilder withTag(String tag, Object value) {
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                this.tags.remove(tag);
            } else {
                this.tags.put(tag, value);
            }
            return this;
        }

        private BigInteger generateNewId() {
            StringCachingBigInteger value;
            while ((value = new StringCachingBigInteger(63, ThreadLocalRandom.current())).signum() == 0) {
            }
            return value;
        }

        private DDSpanContext buildSpanContext() {
            String origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            BigInteger parentSpanId;
            BigInteger traceId;
            AgentSpan activeSpan;
            BigInteger spanId = this.generateNewId();
            Object parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            if (parentContext instanceof DDSpanContext) {
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = Integer.MIN_VALUE;
                origin = null;
                if (this.serviceName == null) {
                    this.serviceName = ddsc.getServiceName();
                }
            } else {
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    baggage = extractedContext.getBaggage();
                } else {
                    traceId = this.generateNewId();
                    parentSpanId = BigInteger.ZERO;
                    samplingPriority = Integer.MIN_VALUE;
                    baggage = null;
                }
                if (parentContext instanceof TagContext) {
                    this.tags.putAll(((TagContext)parentContext).getTags());
                    origin = ((TagContext)parentContext).getOrigin();
                } else {
                    origin = null;
                }
                this.tags.putAll(CoreTracer.this.localRootSpanTags);
                parentTrace = PendingTrace.create(CoreTracer.this, traceId);
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            String operationName = this.operationName != null ? this.operationName : this.resourceName;
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, this.tags, parentTrace, CoreTracer.this, CoreTracer.this.serviceNameMappings);
            for (Map.Entry<String, Object> tag : this.tags.entrySet()) {
                if (tag.getValue() == null) {
                    context.setTag(tag.getKey(), null);
                    continue;
                }
                boolean addTag = true;
                List<AbstractDecorator> decorators = CoreTracer.this.getSpanContextDecorators(tag.getKey());
                if (decorators != null) {
                    for (AbstractDecorator decorator : decorators) {
                        try {
                            addTag &= decorator.shouldSetTag(context, tag.getKey(), tag.getValue());
                        }
                        catch (Throwable ex) {
                            log.debug("Could not decorate the span decorator={}: {}", (Object)decorator.getClass().getSimpleName(), (Object)ex.getMessage());
                        }
                    }
                }
                if (addTag) continue;
                context.setTag(tag.getKey(), null);
            }
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private Writer writer;
        private Sampler sampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private DDScopeManager scopeManager;
        private Map<String, String> localRootSpanTags;
        private Map<String, String> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private int partialFlushMinSpans;

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get((Properties)properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config));
            this.injector(HttpCodec.createInjector(config));
            this.extractor(HttpCodec.createExtractor(config, config.getHeaderTags()));
            this.scopeManager(new ContinuableScopeManager(config.getScopeDepthLimit(), CoreTracer.createScopeEventFactory()));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getHeaderTags());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            return this;
        }

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder scopeManager(DDScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, String> localRootSpanTags) {
            this.localRootSpanTags = localRootSpanTags;
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, String> defaultSpanTags) {
            this.defaultSpanTags = defaultSpanTags;
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = serviceNameMappings;
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = taggedHeaders;
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.writer, this.sampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.partialFlushMinSpans);
        }

        public String toString() {
            return "CoreTracer.CoreTracerBuilder(config=" + this.config + ", serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", injector=" + this.injector + ", extractor=" + this.extractor + ", scopeManager=" + this.scopeManager + ", localRootSpanTags=" + this.localRootSpanTags + ", defaultSpanTags=" + this.defaultSpanTags + ", serviceNameMappings=" + this.serviceNameMappings + ", taggedHeaders=" + this.taggedHeaders + ", partialFlushMinSpans=" + this.partialFlushMinSpans + ")";
        }
    }
}

