/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDSpanTypes;
import datadog.trace.bootstrap.instrumentation.api.DDComponents;
import datadog.trace.bootstrap.instrumentation.api.DDSpanNames;
import datadog.trace.bootstrap.instrumentation.api.Tags;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class StringTables {
    public static final byte[] SERVICE = "service".getBytes(StandardCharsets.UTF_8);
    public static final byte[] NAME = "name".getBytes(StandardCharsets.UTF_8);
    public static final byte[] RESOURCE = "resource".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] START = "start".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DURATION = "duration".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ERROR = "error".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METRICS = "metrics".getBytes(StandardCharsets.UTF_8);
    public static final byte[] META = "meta".getBytes(StandardCharsets.UTF_8);
    private static final Map<String, byte[]> UTF8_INTERN_TABLE = new HashMap<String, byte[]>(256);

    public static byte[] getBytesUTF8(String value) {
        return UTF8_INTERN_TABLE.get(value);
    }

    private static void internConstantsUTF8(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                StringTables.intern(UTF8_INTERN_TABLE, (String)field.get(null), StandardCharsets.UTF_8);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void intern(Map<String, byte[]> table, String value, Charset encoding) {
        table.put(value, value.getBytes(encoding));
    }

    static {
        StringTables.internConstantsUTF8(StringTables.class);
        StringTables.internConstantsUTF8(Tags.class);
        StringTables.internConstantsUTF8(DDSpanTypes.class);
        StringTables.internConstantsUTF8(DDComponents.class);
        StringTables.internConstantsUTF8(DDSpanNames.class);
    }
}

