/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.decorators;

import datadog.trace.core.DDSpanContext;
import datadog.trace.core.decorators.AbstractDecorator;

public class ServletContextDecorator
extends AbstractDecorator {
    public ServletContextDecorator() {
        this.setMatchingTag("servlet.context");
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        String contextName = String.valueOf(value).trim();
        if (contextName.equals("/") || !context.getServiceName().equals("unnamed-java-app") && !context.getServiceName().isEmpty()) {
            return true;
        }
        if (contextName.startsWith("/") && contextName.length() > 1) {
            contextName = contextName.substring(1);
        }
        if (!contextName.isEmpty()) {
            context.setServiceName(contextName);
        }
        return true;
    }
}

