/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.common.exec.CommonTaskExecutor;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.util.Clock;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingTrace
extends ConcurrentLinkedDeque<DDSpan>
implements AgentTrace {
    private static final Logger log = LoggerFactory.getLogger(PendingTrace.class);
    private static final AtomicReference<SpanCleaner> SPAN_CLEANER = new AtomicReference();
    private final CoreTracer tracer;
    private final BigInteger traceId;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final ReferenceQueue spanReferenceQueue = new ReferenceQueue();
    private final Set<WeakReference<DDSpan>> weakSpans = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceQueue continuationReferenceQueue = new ReferenceQueue();
    private final Set<WeakReference<AgentScope.Continuation>> weakContinuations = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger pendingReferenceCount = new AtomicInteger(0);
    private final AtomicInteger completedSpanCount = new AtomicInteger(0);
    private final AtomicReference<WeakReference<DDSpan>> rootSpan = new AtomicReference();
    private final AtomicBoolean isWritten = new AtomicBoolean(false);

    static PendingTrace create(CoreTracer tracer, BigInteger traceId) {
        PendingTrace pendingTrace = new PendingTrace(tracer, traceId);
        pendingTrace.addPendingTrace();
        return pendingTrace;
    }

    private PendingTrace(CoreTracer tracer, BigInteger traceId) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.startTimeNano = Clock.currentNanoTime();
        this.startNanoTicks = Clock.currentNanoTicks();
    }

    public long getCurrentTimeNano() {
        return this.startTimeNano + Math.max(0L, Clock.currentNanoTicks() - this.startNanoTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpan(DDSpan span) {
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to register span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.context().getTraceId())) {
            log.debug("t_id={} -> registered for wrong trace {}", (Object)this.traceId, (Object)span);
            return;
        }
        this.rootSpan.compareAndSet(null, new WeakReference<DDSpan>(span));
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                span.ref = new WeakReference<DDSpan>(span, this.spanReferenceQueue);
                this.weakSpans.add(span.ref);
                int count = this.pendingReferenceCount.incrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug("t_id={} -> registered span {}. count = {}", new Object[]{this.traceId, span, count});
                }
            } else {
                log.debug("t_id={} -> span already registered {}", (Object)this.traceId, (Object)span);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSpan(DDSpan span) {
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to expire span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.context().getTraceId())) {
            log.debug("t_id={} -> span expired for wrong trace {}", (Object)this.traceId, (Object)span);
            return;
        }
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                log.debug("t_id={} -> not registered in trace: {}", (Object)this.traceId, (Object)span);
            } else {
                this.weakSpans.remove(span.ref);
                span.ref.clear();
                span.ref = null;
                this.expireReference();
            }
        }
    }

    public void addSpan(DDSpan span) {
        if (span.getDurationNano() == 0L) {
            log.debug("t_id={} -> added to trace, but not complete: {}", (Object)this.traceId, (Object)span);
            return;
        }
        if (this.traceId == null || span.context() == null) {
            log.error("Failed to add span ({}) due to null PendingTrace traceId or null span context", (Object)span);
            return;
        }
        if (!this.traceId.equals(span.getTraceId())) {
            log.debug("t_id={} -> added to a mismatched trace: {}", (Object)this.traceId, (Object)span);
            return;
        }
        if (!this.isWritten.get()) {
            this.addFirst(span);
        } else {
            log.debug("t_id={} -> finished after trace reported: {}", (Object)this.traceId, (Object)span);
        }
        this.expireSpan(span);
    }

    public DDSpan getRootSpan() {
        WeakReference<DDSpan> rootRef = this.rootSpan.get();
        return rootRef == null ? null : (DDSpan)rootRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContinuation(AgentScope.Continuation continuation) {
        AgentScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (!continuation.isRegistered()) {
                this.weakContinuations.add(continuation.register(this.continuationReferenceQueue));
                int count = this.pendingReferenceCount.incrementAndGet();
                if (log.isDebugEnabled()) {
                    log.debug("t_id={} -> registered continuation {} -- count = {}", new Object[]{this.traceId, continuation, count});
                }
            } else {
                log.debug("continuation {} already registered in trace {}", (Object)continuation, (Object)this.traceId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelContinuation(AgentScope.Continuation continuation) {
        AgentScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.isRegistered()) {
                continuation.cancel(this.weakContinuations);
                this.expireReference();
            } else {
                log.debug("t_id={} -> not registered in trace: {}", (Object)this.traceId, (Object)continuation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireReference() {
        int count = this.pendingReferenceCount.decrementAndGet();
        if (count == 0) {
            this.write();
        } else if (this.tracer.getPartialFlushMinSpans() > 0 && this.size() > this.tracer.getPartialFlushMinSpans()) {
            PendingTrace pendingTrace = this;
            synchronized (pendingTrace) {
                if (this.size() > this.tracer.getPartialFlushMinSpans()) {
                    DDSpan rootSpan = this.getRootSpan();
                    ArrayList<DDSpan> partialTrace = new ArrayList<DDSpan>(this.size());
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        DDSpan span = (DDSpan)it.next();
                        if (span == rootSpan) continue;
                        partialTrace.add(span);
                        this.completedSpanCount.decrementAndGet();
                        it.remove();
                    }
                    log.debug("Writing partial trace {} of size {}", (Object)this.traceId, (Object)partialTrace.size());
                    this.tracer.write(partialTrace);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("t_id={} -> expired reference. count={} spans={} continuations={}", new Object[]{this.traceId, count, this.weakSpans.size(), this.weakContinuations.size()});
        }
    }

    private synchronized void write() {
        if (this.isWritten.compareAndSet(false, true)) {
            this.removePendingTrace();
            if (!this.isEmpty()) {
                log.debug("Writing {} spans to {}.", (Object)this.size(), (Object)this.tracer.writer);
                this.tracer.write(this);
            }
        }
    }

    public synchronized boolean clean() {
        Reference ref;
        int count = 0;
        while ((ref = this.continuationReferenceQueue.poll()) != null) {
            this.weakContinuations.remove(ref);
            ++count;
            this.expireReference();
        }
        if (count > 0) {
            log.debug("t_id={} -> {} unfinished continuations garbage collected.", (Object)this.traceId, (Object)count);
        }
        count = 0;
        while ((ref = this.spanReferenceQueue.poll()) != null) {
            this.weakSpans.remove(ref);
            if (this.isWritten.compareAndSet(false, true)) {
                this.removePendingTrace();
                this.tracer.incrementTraceCount();
            }
            ++count;
            this.expireReference();
        }
        if (count > 0) {
            log.debug("t_id={} -> {} unfinished spans garbage collected. Trace will not be reported.", (Object)this.traceId, (Object)count);
        }
        return count > 0;
    }

    @Override
    public void addFirst(DDSpan span) {
        super.addFirst(span);
        this.completedSpanCount.incrementAndGet();
    }

    @Override
    public int size() {
        return this.completedSpanCount.get();
    }

    private void addPendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.add(this);
        }
    }

    private void removePendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.remove(this);
        }
    }

    static void initialize() {
        SpanCleaner oldCleaner = SPAN_CLEANER.getAndSet(new SpanCleaner());
        if (oldCleaner != null) {
            oldCleaner.close();
        }
    }

    static void close() {
        SpanCleaner cleaner = SPAN_CLEANER.getAndSet(null);
        if (cleaner != null) {
            cleaner.close();
        }
    }

    private static class SpanCleanerTask
    implements CommonTaskExecutor.Task<SpanCleaner> {
        static final SpanCleanerTask INSTANCE = new SpanCleanerTask();

        private SpanCleanerTask() {
        }

        @Override
        public void run(SpanCleaner target) {
            target.run();
        }
    }

    private static class SpanCleaner
    implements Runnable,
    Closeable {
        private static final long CLEAN_FREQUENCY = 1L;
        private final Set<PendingTrace> pendingTraces = Collections.newSetFromMap(new ConcurrentHashMap());

        public SpanCleaner() {
            CommonTaskExecutor.INSTANCE.scheduleAtFixedRate(SpanCleanerTask.INSTANCE, this, 0L, 1L, TimeUnit.SECONDS, "Pending trace cleaner");
        }

        @Override
        public void run() {
            for (PendingTrace trace : this.pendingTraces) {
                trace.clean();
            }
        }

        @Override
        public void close() {
            this.run();
        }
    }
}

