/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.core.propagation.TagContext;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ExtractedContext
extends TagContext {
    private final BigInteger traceId;
    private final BigInteger spanId;
    private final int samplingPriority;
    private final Map<String, String> baggage;
    private final AtomicBoolean samplingPriorityLocked = new AtomicBoolean(false);

    public ExtractedContext(BigInteger traceId, BigInteger spanId, int samplingPriority, String origin, Map<String, String> baggage, Map<String, String> tags) {
        super(origin, tags);
        this.traceId = traceId;
        this.spanId = spanId;
        this.samplingPriority = samplingPriority;
        this.baggage = baggage;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggage.entrySet();
    }

    public void lockSamplingPriority() {
        this.samplingPriorityLocked.set(true);
    }

    public BigInteger getTraceId() {
        return this.traceId;
    }

    public BigInteger getSpanId() {
        return this.spanId;
    }

    public int getSamplingPriority() {
        return this.samplingPriority;
    }

    public Map<String, String> getBaggage() {
        return this.baggage;
    }

    public boolean getSamplingPriorityLocked() {
        return this.samplingPriorityLocked.get();
    }
}

