/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.core.CoreTracer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.PendingTrace;
import datadog.trace.core.decorators.AbstractDecorator;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanContext
implements AgentSpan.Context {
    private static final Logger log = LoggerFactory.getLogger(DDSpanContext.class);
    public static final String PRIORITY_SAMPLING_KEY = "_sampling_priority_v1";
    public static final String SAMPLE_RATE_KEY = "_sample_rate";
    public static final String ORIGIN_KEY = "_dd.origin";
    private static final Map<String, Number> EMPTY_METRICS = Collections.emptyMap();
    private final CoreTracer tracer;
    private final PendingTrace trace;
    private final Map<String, String> baggageItems;
    private final DDId traceId;
    private final DDId spanId;
    private final DDId parentId;
    private final Map<String, Object> tags = new ConcurrentHashMap<String, Object>();
    private volatile String serviceName;
    private volatile String resourceName;
    private volatile String operationName;
    private volatile String spanType;
    private volatile boolean errorFlag;
    private boolean samplingPriorityLocked = false;
    private final String origin;
    private final AtomicReference<Map<String, Number>> metrics = new AtomicReference();
    private final String threadName = Thread.currentThread().getName();
    private final long threadId = Thread.currentThread().getId();
    private final Map<String, String> serviceNameMappings;

    public DDSpanContext(DDId traceId, DDId spanId, DDId parentId, String serviceName, String operationName, String resourceName, int samplingPriority, String origin, Map<String, String> baggageItems, boolean errorFlag, String spanType, Map<String, Object> tags, PendingTrace trace, CoreTracer tracer, Map<String, String> serviceNameMappings) {
        assert (tracer != null);
        assert (trace != null);
        this.tracer = tracer;
        this.trace = trace;
        assert (traceId != null);
        assert (spanId != null);
        assert (parentId != null);
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.baggageItems = baggageItems == null ? new ConcurrentHashMap<String, String>(0) : new ConcurrentHashMap<String, String>(baggageItems);
        if (tags != null) {
            this.tags.putAll(tags);
        }
        this.serviceNameMappings = serviceNameMappings;
        this.setServiceName(serviceName);
        this.operationName = operationName;
        this.resourceName = resourceName;
        this.errorFlag = errorFlag;
        this.spanType = spanType;
        this.origin = origin;
        if (samplingPriority != Integer.MIN_VALUE) {
            this.setSamplingPriority(samplingPriority);
        }
        if (origin != null) {
            this.tags.put(ORIGIN_KEY, origin);
        }
        this.tags.put("thread.name", this.threadName);
        this.tags.put("thread.id", this.threadId);
    }

    @Override
    public DDId getTraceId() {
        return this.traceId;
    }

    public DDId getParentId() {
        return this.parentId;
    }

    @Override
    public DDId getSpanId() {
        return this.spanId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = this.serviceNameMappings.containsKey(serviceName) ? this.serviceNameMappings.get(serviceName) : serviceName;
    }

    public String getResourceName() {
        return this.isResourceNameSet() ? this.resourceName : this.operationName;
    }

    public boolean isResourceNameSet() {
        return this.resourceName != null && !this.resourceName.isEmpty();
    }

    public boolean hasResourceName() {
        return this.isResourceNameSet() || this.tags.containsKey("resource.name");
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public boolean getErrorFlag() {
        return this.errorFlag;
    }

    public void setErrorFlag(boolean errorFlag) {
        this.errorFlag = errorFlag;
    }

    public String getSpanType() {
        return this.spanType;
    }

    public void setSpanType(String spanType) {
        this.spanType = spanType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSamplingPriority(int newPriority) {
        DDSpan rootSpan;
        if (newPriority == Integer.MIN_VALUE) {
            log.debug("{}: Refusing to set samplingPriority to UNSET", (Object)this);
            return false;
        }
        if (this.trace != null && null != (rootSpan = this.trace.getRootSpan()) && rootSpan.context() != this) {
            return rootSpan.context().setSamplingPriority(newPriority);
        }
        DDSpanContext dDSpanContext = this;
        synchronized (dDSpanContext) {
            if (this.samplingPriorityLocked) {
                log.debug("samplingPriority locked at {}. Refusing to set to {}", (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY), (Object)newPriority);
                return false;
            }
            this.setMetric(PRIORITY_SAMPLING_KEY, newPriority);
            log.debug("Set sampling priority to {}", (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY));
            return true;
        }
    }

    public int getSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().getSamplingPriority();
        }
        Number val = this.getMetrics().get(PRIORITY_SAMPLING_KEY);
        return null == val ? Integer.MIN_VALUE : val.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lockSamplingPriority() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan && rootSpan.context() != this) {
            return rootSpan.context().lockSamplingPriority();
        }
        DDSpanContext dDSpanContext = this;
        synchronized (dDSpanContext) {
            if (this.getMetrics().get(PRIORITY_SAMPLING_KEY) == null) {
                log.debug("{} : refusing to lock unset samplingPriority", (Object)this);
            } else if (!this.samplingPriorityLocked) {
                this.samplingPriorityLocked = true;
                log.debug("{} : locked samplingPriority to {}", (Object)this, (Object)this.getMetrics().get(PRIORITY_SAMPLING_KEY));
            }
            return this.samplingPriorityLocked;
        }
    }

    public String getOrigin() {
        DDSpan rootSpan = this.trace.getRootSpan();
        if (null != rootSpan) {
            return rootSpan.context().origin;
        }
        return this.origin;
    }

    public void setBaggageItem(String key, String value) {
        this.baggageItems.put(key, value);
    }

    public String getBaggageItem(String key) {
        return this.baggageItems.get(key);
    }

    public Map<String, String> getBaggageItems() {
        return this.baggageItems;
    }

    @Override
    public Iterable<Map.Entry<String, String>> baggageItems() {
        return this.baggageItems.entrySet();
    }

    @Override
    public PendingTrace getTrace() {
        return this.trace;
    }

    @Deprecated
    public CoreTracer getTracer() {
        return this.tracer;
    }

    public Map<String, Number> getMetrics() {
        Map<String, Number> metrics = this.metrics.get();
        return metrics == null ? EMPTY_METRICS : metrics;
    }

    public void setMetric(String key, Number value) {
        if (this.metrics.get() == null) {
            this.metrics.compareAndSet(null, new ConcurrentHashMap());
        }
        if (value instanceof Float) {
            this.metrics.get().put(key, value.doubleValue());
        } else {
            this.metrics.get().put(key, value);
        }
    }

    public synchronized void setTag(String tag, Object value) {
        if (value == null || value instanceof String && ((String)value).isEmpty()) {
            this.tags.remove(tag);
            return;
        }
        boolean addTag = true;
        List<AbstractDecorator> decorators = this.tracer.getSpanContextDecorators(tag);
        if (decorators != null) {
            for (AbstractDecorator decorator : decorators) {
                try {
                    addTag &= decorator.shouldSetTag(this, tag, value);
                }
                catch (Throwable ex) {
                    log.debug("Could not decorate the span decorator={}: {}", (Object)decorator.getClass().getSimpleName(), (Object)ex.getMessage());
                }
            }
        }
        if (addTag) {
            this.tags.put(tag, value);
        }
    }

    public Map<String, Object> getTags() {
        return this.tags;
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("DDSpan [ t_id=").append(this.traceId).append(", s_id=").append(this.spanId).append(", p_id=").append(this.parentId).append("] trace=").append(this.getServiceName()).append("/").append(this.getOperationName()).append("/").append(this.getResourceName()).append(" metrics=").append(new TreeMap<String, Number>(this.getMetrics()));
        if (this.errorFlag) {
            s.append(" *errored*");
        }
        s.append(" tags=").append(new TreeMap<String, Object>(this.tags));
        return s.toString();
    }
}

