/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import datadog.trace.api.DDId;
import datadog.trace.core.StringTables;
import datadog.trace.core.serialization.FormatWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import org.msgpack.core.MessagePacker;

public class MsgpackFormatWriter
extends FormatWriter<MessagePacker> {
    public static MsgpackFormatWriter MSGPACK_WRITER = new MsgpackFormatWriter();
    private final LoadingCache<String, byte[]> tagCache = CacheBuilder.newBuilder().maximumSize(64L).concurrencyLevel(1).build((CacheLoader)new CacheLoader<String, byte[]>(){

        public byte[] load(String key) throws Exception {
            return key.getBytes(StandardCharsets.UTF_8);
        }
    });

    @Override
    public void writeKey(byte[] key, MessagePacker destination) throws IOException {
        destination.packRawStringHeader(key.length);
        destination.addPayload(key);
    }

    @Override
    public void writeListHeader(int size, MessagePacker destination) throws IOException {
        destination.packArrayHeader(size);
    }

    @Override
    public void writeListFooter(MessagePacker destination) {
    }

    @Override
    public void writeMapHeader(int size, MessagePacker destination) throws IOException {
        destination.packMapHeader(size);
    }

    @Override
    public void writeMapFooter(MessagePacker destination) {
    }

    @Override
    public void writeString(byte[] key, String value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        if (value == null) {
            destination.packNil();
        } else {
            destination.packString(value);
        }
    }

    @Override
    public void writeTag(byte[] key, String value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        this.writeUTF8Tag(value, destination);
    }

    @Override
    public void writeShort(byte[] key, short value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packShort(value);
    }

    @Override
    public void writeByte(byte[] key, byte value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packByte(value);
    }

    @Override
    public void writeInt(byte[] key, int value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packInt(value);
    }

    @Override
    public void writeLong(byte[] key, long value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packLong(value);
    }

    @Override
    public void writeFloat(byte[] key, float value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packFloat(value);
    }

    @Override
    public void writeDouble(byte[] key, double value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packDouble(value);
    }

    @Override
    public void writeId(byte[] key, DDId id, MessagePacker destination) throws IOException {
        this.writeLong(key, id.toLong(), destination);
    }

    private void writeUTF8Tag(String value, MessagePacker destination) throws IOException {
        if (null == value) {
            destination.packNil();
        } else {
            byte[] interned = StringTables.getTagBytesUTF8(value);
            if (null != interned) {
                destination.packRawStringHeader(interned.length);
                destination.addPayload(interned);
            } else {
                byte[] bytes = null;
                if (value.length() > 0) {
                    try {
                        bytes = (byte[])this.tagCache.get((Object)value);
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
                if (bytes != null) {
                    destination.packRawStringHeader(bytes.length);
                    destination.addPayload(bytes);
                } else {
                    destination.packString(value);
                }
            }
        }
    }
}

