/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor.rule;

import datadog.trace.api.Config;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;

public class HttpStatusErrorRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[0];
    }

    @Override
    public void processSpan(DDSpan span) {
        Object value = span.getTag("http.status_code");
        if (value != null && !span.context().getErrorFlag()) {
            try {
                int status;
                int n = status = value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
                if ("web".equals(span.getType())) {
                    if (Config.get().getHttpServerErrorStatuses().get(status)) {
                        span.setError(true);
                    }
                } else if ("http".equals(span.getType()) && Config.get().getHttpClientErrorStatuses().get(status)) {
                    span.setError(true);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

