/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.taginterceptor;

import datadog.trace.api.Config;
import datadog.trace.core.taginterceptor.AbstractTagInterceptor;
import datadog.trace.core.taginterceptor.DBTypeTagInterceptor;
import datadog.trace.core.taginterceptor.ForceManualDropTagInterceptor;
import datadog.trace.core.taginterceptor.ForceManualKeepTagInterceptor;
import datadog.trace.core.taginterceptor.PeerServiceTagInterceptor;
import datadog.trace.core.taginterceptor.ServiceNameTagInterceptor;
import datadog.trace.core.taginterceptor.ServletContextTagInterceptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagInterceptorsFactory {
    private static final Logger log = LoggerFactory.getLogger(TagInterceptorsFactory.class);

    public static List<AbstractTagInterceptor> createTagInterceptors() {
        ArrayList<AbstractTagInterceptor> interceptors = new ArrayList<AbstractTagInterceptor>();
        for (AbstractTagInterceptor interceptor : Arrays.asList(new DBTypeTagInterceptor(), new ForceManualDropTagInterceptor(), new ForceManualKeepTagInterceptor(), new PeerServiceTagInterceptor(), new ServiceNameTagInterceptor(), new ServiceNameTagInterceptor("service", false), new ServletContextTagInterceptor())) {
            if (Config.get().isRuleEnabled(interceptor.getClass().getSimpleName())) {
                interceptors.add(interceptor);
                continue;
            }
            log.debug("{} disabled", (Object)interceptor.getClass().getSimpleName());
        }
        for (String splitByTag : Config.get().getSplitByTags()) {
            interceptors.add(new ServiceNameTagInterceptor(splitByTag, true));
        }
        return interceptors;
    }
}

