/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import datadog.common.exec.DaemonThreadFactory;
import datadog.trace.common.writer.DDAgentWriter;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DisruptorUtils;
import datadog.trace.common.writer.ddagent.Monitor;
import datadog.trace.common.writer.ddagent.TraceBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchingDisruptor
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(DispatchingDisruptor.class);
    private final Disruptor<TraceBuffer> disruptor;

    public DispatchingDisruptor(int disruptorSize, EventFactory<TraceBuffer> eventFactory, DDAgentApi api, Monitor monitor, final DDAgentWriter writer) {
        this.disruptor = DisruptorUtils.create(eventFactory, disruptorSize, DaemonThreadFactory.TRACE_WRITER.withInitializer(new Runnable(){

            @Override
            public void run() {
                writer.getApi().detectEndpointAndBuildClient();
            }
        }), ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWith(new EventHandler[]{new TraceDispatchingHandler(api, monitor, writer)});
    }

    public void start() {
        this.disruptor.start();
    }

    @Override
    public void close() {
        this.disruptor.halt();
    }

    long beginTransaction() {
        return this.disruptor.getRingBuffer().next();
    }

    TraceBuffer getTraceBuffer(long sequence) {
        return (TraceBuffer)this.disruptor.getRingBuffer().get(sequence);
    }

    void commit(long sequence) {
        this.disruptor.getRingBuffer().publish(sequence);
    }

    private static class TraceDispatchingHandler
    implements EventHandler<TraceBuffer> {
        private final DDAgentApi api;
        private final Monitor monitor;
        private final DDAgentWriter writer;

        private TraceDispatchingHandler(DDAgentApi api, Monitor monitor, DDAgentWriter writer) {
            this.api = api;
            this.monitor = monitor;
            this.writer = writer;
        }

        public void onEvent(TraceBuffer event, long sequence, boolean endOfBatch) {
            this.sendData(event);
        }

        private void sendData(TraceBuffer traces) {
            if (log.isDebugEnabled()) {
                log.debug("receive id={}, rc={}, tc={}", new Object[]{traces.id(), traces.representativeCount(), traces.traceCount()});
            }
            try {
                if (traces.traceCount() > 0) {
                    DDAgentApi.Response response = this.api.sendSerializedTraces(traces);
                    if (response.success()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully sent {} traces {} to the API", (Object)traces.traceCount(), (Object)traces.id());
                        }
                        this.monitor.onSend(this.writer, traces.representativeCount(), traces.sizeInBytes(), response);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Failed to send {} traces (representing {}) of size {} bytes to the API", new Object[]{traces.traceCount(), traces.representativeCount(), traces.sizeInBytes()});
                        }
                        this.monitor.onFailedSend(this.writer, traces.representativeCount(), traces.sizeInBytes(), response);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("buffer {} was empty", (Object)traces.id());
                }
            }
            catch (Throwable e) {
                log.debug("Failed to send traces to the API: {}", (Object)e.getMessage(), (Object)e);
                this.monitor.onFailedSend(this.writer, traces.representativeCount(), traces.sizeInBytes(), DDAgentApi.Response.failed(e));
            }
            finally {
                traces.onDispatched();
            }
        }
    }
}

