/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanTypes;
import datadog.trace.api.DDTags;
import datadog.trace.bootstrap.instrumentation.api.CommonTagValues;
import datadog.trace.bootstrap.instrumentation.api.DDComponents;
import datadog.trace.bootstrap.instrumentation.api.DDSpanNames;
import datadog.trace.bootstrap.instrumentation.api.InstrumentationTags;
import datadog.trace.bootstrap.instrumentation.api.Tags;
import datadog.trace.core.DDSpanContext;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StringTables {
    public static final byte[] SERVICE = "service".getBytes(StandardCharsets.UTF_8);
    public static final byte[] NAME = "name".getBytes(StandardCharsets.UTF_8);
    public static final byte[] RESOURCE = "resource".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TRACE_ID = "trace_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] SPAN_ID = "span_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] PARENT_ID = "parent_id".getBytes(StandardCharsets.UTF_8);
    public static final byte[] START = "start".getBytes(StandardCharsets.UTF_8);
    public static final byte[] DURATION = "duration".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ERROR = "error".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METRICS = "metrics".getBytes(StandardCharsets.UTF_8);
    public static final byte[] META = "meta".getBytes(StandardCharsets.UTF_8);
    private static final Map<String, byte[]> UTF8_INTERN_KEYS_TABLE = new HashMap<String, byte[]>(256);
    private static final Map<String, byte[]> UTF8_INTERN_TAGS_TABLE = new HashMap<String, byte[]>(256);
    private static final int MAX_TAGS_LENGTH;
    private static final long[] TAGS_FIRST_CHAR_IS_PRESENT;

    public static byte[] getKeyBytesUTF8(String value) {
        return UTF8_INTERN_KEYS_TABLE.get(value);
    }

    public static byte[] getTagBytesUTF8(String value) {
        return StringTables.tagMaybeInterned(value) ? UTF8_INTERN_TAGS_TABLE.get(value) : null;
    }

    private static void internConstantsUTF8(Class<?> clazz, Map<String, byte[]> map, long[] firstByteBitmap) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                StringTables.intern(map, (String)field.get(null), StandardCharsets.UTF_8, firstByteBitmap);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static void intern(Map<String, byte[]> table, String value, Charset encoding, long[] firstByteBitmap) {
        byte[] bytes = value.getBytes(encoding);
        if (null != firstByteBitmap && bytes.length > 0) {
            int bit = bytes[0] & 0xFF;
            int n = bit >>> 6;
            firstByteBitmap[n] = firstByteBitmap[n] | 1L << bit;
        }
        table.put(value, bytes);
    }

    private static boolean tagMaybeInterned(String tag) {
        char first;
        if (null == tag || tag.length() > MAX_TAGS_LENGTH) {
            return false;
        }
        return tag.isEmpty() || (first = tag.charAt(0)) >= '\u0100' || (TAGS_FIRST_CHAR_IS_PRESENT[first >>> 6] & 1L << first) != 0L;
    }

    private static int maxKeyLength(Set<String> keys) {
        int max = 0;
        for (String key : keys) {
            max = Math.max(key.length(), max);
        }
        return max;
    }

    static {
        TAGS_FIRST_CHAR_IS_PRESENT = new long[4];
        StringTables.internConstantsUTF8(DDSpanContext.class, UTF8_INTERN_KEYS_TABLE, null);
        StringTables.internConstantsUTF8(DDTags.class, UTF8_INTERN_KEYS_TABLE, null);
        StringTables.internConstantsUTF8(Tags.class, UTF8_INTERN_KEYS_TABLE, null);
        StringTables.internConstantsUTF8(InstrumentationTags.class, UTF8_INTERN_KEYS_TABLE, null);
        StringTables.internConstantsUTF8(DDSpanTypes.class, UTF8_INTERN_TAGS_TABLE, TAGS_FIRST_CHAR_IS_PRESENT);
        StringTables.internConstantsUTF8(DDComponents.class, UTF8_INTERN_TAGS_TABLE, TAGS_FIRST_CHAR_IS_PRESENT);
        StringTables.internConstantsUTF8(DDSpanNames.class, UTF8_INTERN_TAGS_TABLE, TAGS_FIRST_CHAR_IS_PRESENT);
        StringTables.internConstantsUTF8(CommonTagValues.class, UTF8_INTERN_TAGS_TABLE, TAGS_FIRST_CHAR_IS_PRESENT);
        StringTables.intern(UTF8_INTERN_TAGS_TABLE, Config.get().getServiceName(), StandardCharsets.UTF_8, TAGS_FIRST_CHAR_IS_PRESENT);
        StringTables.intern(UTF8_INTERN_KEYS_TABLE, "_dd.agent_psr", StandardCharsets.UTF_8, null);
        UTF8_INTERN_TAGS_TABLE.put("", new byte[0]);
        MAX_TAGS_LENGTH = StringTables.maxKeyLength(UTF8_INTERN_TAGS_TABLE.keySet());
    }
}

