/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.common.container.ContainerInfo;
import datadog.common.exec.CommonTaskExecutor;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.TraceBuffer;
import datadog.trace.common.writer.unixdomainsockets.UnixDomainSocketFactory;
import datadog.trace.core.DDTraceCoreInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import okhttp3.ConnectionSpec;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentApi {
    private static final Logger log = LoggerFactory.getLogger(DDAgentApi.class);
    private static final String DATADOG_META_LANG = "Datadog-Meta-Lang";
    private static final String DATADOG_META_LANG_VERSION = "Datadog-Meta-Lang-Version";
    private static final String DATADOG_META_LANG_INTERPRETER = "Datadog-Meta-Lang-Interpreter";
    private static final String DATADOG_META_LANG_INTERPRETER_VENDOR = "Datadog-Meta-Lang-Interpreter-Vendor";
    private static final String DATADOG_META_TRACER_VERSION = "Datadog-Meta-Tracer-Version";
    private static final String DATADOG_CONTAINER_ID = "Datadog-Container-ID";
    private static final String X_DATADOG_TRACE_COUNT = "X-Datadog-Trace-Count";
    private static final String TRACES_ENDPOINT_V3 = "v0.3/traces";
    private static final String TRACES_ENDPOINT_V4 = "v0.4/traces";
    private static final long NANOSECONDS_BETWEEN_ERROR_LOG = TimeUnit.MINUTES.toNanos(5L);
    private static final String WILL_NOT_LOG_FOR_MESSAGE = "(Will not log errors for 5 minutes)";
    private final List<DDAgentResponseListener> responseListeners = new ArrayList<DDAgentResponseListener>();
    private long previousErrorLogNanos = System.nanoTime() - NANOSECONDS_BETWEEN_ERROR_LOG;
    private boolean logNextSuccess = false;
    private long totalTraces = 0L;
    private long receivedTraces = 0L;
    private long sentTraces = 0L;
    private long failedTraces = 0L;
    private static final JsonAdapter<Map<String, Map<String, Number>>> RESPONSE_ADAPTER = new Moshi.Builder().build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Double.class})}));
    private static final MediaType MSGPACK = MediaType.get((String)"application/msgpack");
    private final String host;
    private final int port;
    private final String unixDomainSocketPath;
    private final long timeoutMillis;
    private OkHttpClient httpClient;
    private HttpUrl tracesUrl;
    private static final byte[] EMPTY_LIST = new byte[]{-112};

    public DDAgentApi(String host, int port, String unixDomainSocketPath, long timeoutMillis) {
        this.host = host;
        this.port = port;
        this.unixDomainSocketPath = unixDomainSocketPath;
        this.timeoutMillis = timeoutMillis;
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        if (!this.responseListeners.contains(listener)) {
            this.responseListeners.add(listener);
        }
    }

    /*
     * Loose catch block
     */
    Response sendSerializedTraces(TraceBuffer traces) {
        Object parsedResponse;
        String responseString;
        Throwable throwable;
        okhttp3.Response response;
        block30: {
            block31: {
                block27: {
                    Response response2;
                    block28: {
                        block29: {
                            if (this.httpClient == null) {
                                this.detectEndpointAndBuildClient();
                            }
                            Request request = DDAgentApi.prepareRequest(this.tracesUrl).addHeader(X_DATADOG_TRACE_COUNT, Integer.toString(traces.representativeCount())).put((RequestBody)new MsgPackRequestBody(traces)).build();
                            this.totalTraces += (long)traces.representativeCount();
                            this.receivedTraces += (long)traces.traceCount();
                            response = this.httpClient.newCall(request).execute();
                            throwable = null;
                            if (response.code() == 200) break block27;
                            this.countAndLogFailedSend(traces, response, null);
                            response2 = Response.failed(response.code());
                            if (response == null) break block28;
                            if (throwable == null) break block29;
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block28;
                        }
                        response.close();
                    }
                    return response2;
                }
                this.countAndLogSuccessfulSend(traces);
                responseString = null;
                responseString = response.body().string().trim();
                if (!"".equals(responseString) && !"OK".equalsIgnoreCase(responseString)) {
                    parsedResponse = (Map)RESPONSE_ADAPTER.fromJson(responseString);
                    String endpoint = this.tracesUrl.toString();
                    for (DDAgentResponseListener listener : this.responseListeners) {
                        listener.onResponse(endpoint, (Map<String, Map<String, Number>>)parsedResponse);
                    }
                }
                parsedResponse = Response.success(response.code());
                if (response == null) break block30;
                if (throwable == null) break block31;
                try {
                    response.close();
                }
                catch (Throwable throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                break block30;
            }
            response.close();
        }
        return parsedResponse;
        {
            catch (IOException e) {
                Response response3;
                block32: {
                    block33: {
                        log.debug("Failed to parse DD agent response: {}", (Object)responseString, (Object)e);
                        response3 = Response.success(response.code(), e);
                        if (response == null) break block32;
                        if (throwable == null) break block33;
                        try {
                            response.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        break block32;
                    }
                    response.close();
                }
                return response3;
                {
                    catch (Throwable throwable5) {
                        try {
                            try {
                                throwable = throwable5;
                                throw throwable5;
                            }
                            catch (Throwable throwable6) {
                                if (response != null) {
                                    if (throwable != null) {
                                        try {
                                            response.close();
                                        }
                                        catch (Throwable throwable7) {
                                            throwable.addSuppressed(throwable7);
                                        }
                                    } else {
                                        response.close();
                                    }
                                }
                                throw throwable6;
                            }
                        }
                        catch (IOException e2) {
                            this.countAndLogFailedSend(traces, null, e2);
                            return Response.failed(e2);
                        }
                    }
                }
            }
        }
    }

    private void countAndLogSuccessfulSend(TraceBuffer traces) {
        this.sentTraces += (long)traces.traceCount();
        if (log.isDebugEnabled()) {
            log.debug(this.createSendLogMessage(traces, "Success"));
        } else if (this.logNextSuccess) {
            this.logNextSuccess = false;
            if (log.isInfoEnabled()) {
                log.info(this.createSendLogMessage(traces, "Success"));
            }
        }
    }

    private void countAndLogFailedSend(TraceBuffer traces, okhttp3.Response response, IOException outer) {
        long now;
        this.failedTraces += (long)traces.traceCount();
        IOException exception = outer;
        boolean hasLogged = false;
        if (log.isDebugEnabled()) {
            String sendErrorString = this.createSendLogMessage(traces, "Error");
            if (response != null) {
                try {
                    log.debug("{} Status: {}, Response: {}, Body: {}", new Object[]{sendErrorString, response.code(), response.message(), response.body().string().trim()});
                    hasLogged = true;
                }
                catch (IOException inner) {
                    exception = inner;
                }
            } else if (exception != null) {
                log.debug(sendErrorString, (Throwable)exception);
                hasLogged = true;
            } else {
                log.debug(sendErrorString);
                hasLogged = true;
            }
        }
        if (!hasLogged && log.isWarnEnabled() && (now = System.nanoTime()) - this.previousErrorLogNanos >= NANOSECONDS_BETWEEN_ERROR_LOG) {
            this.previousErrorLogNanos = now;
            this.logNextSuccess = true;
            String sendErrorString = this.createSendLogMessage(traces, "Error");
            if (response != null) {
                log.warn("{} Status: {} {} {}", new Object[]{sendErrorString, response.code(), response.message(), WILL_NOT_LOG_FOR_MESSAGE});
            } else if (exception != null) {
                log.warn("{} {}: {} {}", new Object[]{sendErrorString, exception.getClass().getName(), exception.getMessage(), WILL_NOT_LOG_FOR_MESSAGE});
            } else {
                log.warn("{} {}", (Object)sendErrorString, (Object)WILL_NOT_LOG_FOR_MESSAGE);
            }
        }
    }

    private String createSendLogMessage(TraceBuffer traces, String prefix) {
        int size = traces.sizeInBytes();
        String sizeString = size > 1024 ? String.valueOf(size / 1024) + "KB" : String.valueOf(size) + "B";
        return prefix + " while sending " + traces.traceCount() + " of " + traces.representativeCount() + " (size=" + sizeString + ") traces to the DD agent. Total: " + this.totalTraces + ", Received: " + this.receivedTraces + ", Sent: " + this.sentTraces + ", Failed: " + this.failedTraces + ".";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean endpointAvailable(HttpUrl url, String unixDomainSocketPath, long timeoutMillis, boolean retry) {
        try {
            OkHttpClient client = DDAgentApi.buildHttpClient(unixDomainSocketPath, timeoutMillis);
            RequestBody body = RequestBody.create((MediaType)MSGPACK, (byte[])EMPTY_LIST);
            Request request = DDAgentApi.prepareRequest(url).put(body).build();
            try (okhttp3.Response response = client.newCall(request).execute();){
                boolean bl = response.code() == 200;
                return bl;
            }
        }
        catch (IOException e) {
            if (!retry) return false;
            return DDAgentApi.endpointAvailable(url, unixDomainSocketPath, timeoutMillis, false);
        }
    }

    private static OkHttpClient buildHttpClient(String unixDomainSocketPath, long timeoutMillis) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (unixDomainSocketPath != null) {
            builder = builder.socketFactory((SocketFactory)new UnixDomainSocketFactory(new File(unixDomainSocketPath)));
        }
        return builder.connectTimeout(timeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(timeoutMillis, TimeUnit.MILLISECONDS).readTimeout(timeoutMillis, TimeUnit.MILLISECONDS).connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT)).dispatcher(new Dispatcher((ExecutorService)CommonTaskExecutor.INSTANCE)).build();
    }

    private static HttpUrl getUrl(String host, int port, String endPoint) {
        return new HttpUrl.Builder().scheme("http").host(host).port(port).addEncodedPathSegments(endPoint).build();
    }

    private static Request.Builder prepareRequest(HttpUrl url) {
        Request.Builder builder = new Request.Builder().url(url).addHeader(DATADOG_META_LANG, "java").addHeader(DATADOG_META_LANG_VERSION, DDTraceCoreInfo.JAVA_VERSION).addHeader(DATADOG_META_LANG_INTERPRETER, DDTraceCoreInfo.JAVA_VM_NAME).addHeader(DATADOG_META_LANG_INTERPRETER_VENDOR, DDTraceCoreInfo.JAVA_VM_VENDOR).addHeader(DATADOG_META_TRACER_VERSION, DDTraceCoreInfo.VERSION);
        String containerId = ContainerInfo.get().getContainerId();
        if (containerId == null) {
            return builder;
        }
        return builder.addHeader(DATADOG_CONTAINER_ID, containerId);
    }

    void detectEndpointAndBuildClient() {
        if (this.httpClient == null) {
            HttpUrl v4Url = DDAgentApi.getUrl(this.host, this.port, TRACES_ENDPOINT_V4);
            if (DDAgentApi.endpointAvailable(v4Url, this.unixDomainSocketPath, this.timeoutMillis, true)) {
                this.tracesUrl = v4Url;
            } else {
                log.debug("API v0.4 endpoints not available. Downgrading to v0.3");
                this.tracesUrl = DDAgentApi.getUrl(this.host, this.port, TRACES_ENDPOINT_V3);
            }
            this.httpClient = DDAgentApi.buildHttpClient(this.unixDomainSocketPath, this.timeoutMillis);
        }
    }

    private static class MsgPackRequestBody
    extends RequestBody {
        private final TraceBuffer traces;

        private MsgPackRequestBody(TraceBuffer traces) {
            this.traces = traces;
        }

        public MediaType contentType() {
            return MSGPACK;
        }

        public long contentLength() {
            return this.traces.headerSize() + this.traces.sizeInBytes();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            this.traces.writeTo((WritableByteChannel)sink);
            sink.flush();
        }
    }

    public static final class Response {
        private final boolean success;
        private final Integer status;
        private final Throwable exception;

        public static Response success(int status) {
            return new Response(true, status, null);
        }

        public static Response success(int status, Throwable exception) {
            return new Response(true, status, exception);
        }

        public static Response failed(int status) {
            return new Response(false, status, null);
        }

        public static Response failed(Throwable exception) {
            return new Response(false, null, exception);
        }

        private Response(boolean success, Integer status, Throwable exception) {
            this.success = success;
            this.status = status;
            this.exception = exception;
        }

        public final boolean success() {
            return this.success;
        }

        public final Integer status() {
            return this.status;
        }

        public final Throwable exception() {
            return this.exception;
        }
    }
}

