/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer.ddagent;

import datadog.trace.common.writer.ddagent.StatefulSerializer;
import datadog.trace.common.writer.ddagent.TraceBuffer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.serialization.MsgpackFormatWriter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessagePacker;
import org.msgpack.core.buffer.ArrayBufferOutput;
import org.msgpack.core.buffer.MessageBuffer;
import org.msgpack.core.buffer.MessageBufferOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsgPackStatefulSerializer
implements StatefulSerializer {
    private static final Logger log = LoggerFactory.getLogger(MsgPackStatefulSerializer.class);
    public static final int DEFAULT_BUFFER_THRESHOLD = 0x100000;
    private static final int TRACE_HISTORY_SIZE = 16;
    private static final int INITIAL_TRACE_SIZE_ESTIMATE = 8192;
    private static final MessagePack.PackerConfig MESSAGE_PACKER_CONFIG = MessagePack.DEFAULT_PACKER_CONFIG.withSmallStringOptimizationThreshold(0);
    private final MessagePacker messagePacker;
    private final int[] traceSizeHistory = new int[16];
    private final int sizeThresholdBytes;
    private final int bufferSize;
    private int runningTraceSizeSum;
    private int position;
    private MsgPackTraceBuffer traceBuffer;
    private int currentSerializedBytes = 0;

    public MsgPackStatefulSerializer() {
        this(0x100000, 0x200000);
    }

    public MsgPackStatefulSerializer(int sizeThresholdBytes, int bufferSize) {
        Arrays.fill(this.traceSizeHistory, 8192);
        this.runningTraceSizeSum = 131072;
        this.sizeThresholdBytes = sizeThresholdBytes;
        this.bufferSize = bufferSize;
        this.messagePacker = MESSAGE_PACKER_CONFIG.newPacker((MessageBufferOutput)new ArrayBufferOutput(0));
    }

    @Override
    public int serialize(List<DDSpan> trace) throws IOException {
        MsgpackFormatWriter.MSGPACK_WRITER.writeTrace(trace, this.messagePacker);
        int newSerializedSize = (int)this.messagePacker.getTotalWrittenBytes();
        int serializedSize = newSerializedSize - this.currentSerializedBytes;
        this.currentSerializedBytes = newSerializedSize;
        this.updateTraceSizeEstimate(serializedSize);
        ++this.traceBuffer.traceCount;
        this.traceBuffer.length = newSerializedSize;
        return serializedSize;
    }

    @Override
    public void dropBuffer() throws IOException {
        this.messagePacker.flush();
        this.traceBuffer = null;
    }

    @Override
    public boolean isAtCapacity() {
        return this.currentSerializedBytes + this.avgTraceSize() >= this.sizeThresholdBytes;
    }

    @Override
    public void reset(TraceBuffer buffer) {
        if (buffer instanceof MsgPackTraceBuffer) {
            this.traceBuffer = (MsgPackTraceBuffer)buffer;
            this.traceBuffer.reset();
        } else {
            this.traceBuffer = this.newBuffer();
        }
        this.messagePacker.clear();
        try {
            this.messagePacker.reset((MessageBufferOutput)this.traceBuffer.buffer);
        }
        catch (IOException e) {
            log.error("Unexpected exception resetting MessagePacker buffer", (Throwable)e);
        }
    }

    @Override
    public MsgPackTraceBuffer newBuffer() {
        return new MsgPackTraceBuffer(new ArrayBufferOutput(this.bufferSize));
    }

    private void updateTraceSizeEstimate(int traceSize) {
        this.runningTraceSizeSum = this.runningTraceSizeSum - this.traceSizeHistory[this.position] + traceSize;
        this.traceSizeHistory[this.position] = traceSize;
        this.position = this.position + 1 & this.traceSizeHistory.length - 1;
    }

    private int avgTraceSize() {
        return this.runningTraceSizeSum / 16;
    }

    static class MsgPackTraceBuffer
    implements TraceBuffer {
        private static final AtomicInteger BUFFER_ID = new AtomicInteger(0);
        private final ArrayBufferOutput buffer;
        final int id;
        private int length;
        private int traceCount;
        private int representativeCount;
        private Runnable flush;

        public MsgPackTraceBuffer(ArrayBufferOutput buffer) {
            this.buffer = buffer;
            this.id = BUFFER_ID.getAndIncrement();
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            this.writeHeader(channel);
            int remaining = this.length;
            for (MessageBuffer messageBuffer : this.buffer.toBufferList()) {
                int size = messageBuffer.size();
                ByteBuffer buffer = messageBuffer.sliceAsByteBuffer(0, Math.min(size, remaining));
                while (buffer.hasRemaining()) {
                    remaining -= channel.write(buffer);
                }
            }
            assert (remaining == 0);
        }

        private void writeHeader(WritableByteChannel channel) throws IOException {
            if (this.traceCount < 16) {
                ByteBuffer buffer = ByteBuffer.allocate(1);
                buffer.put(0, (byte)(this.traceCount | 0xFFFFFF90));
                channel.write(buffer);
            } else if (this.traceCount < 65536) {
                ByteBuffer buffer = ByteBuffer.allocate(3);
                buffer.put(0, (byte)-36);
                buffer.putShort(1, (short)this.traceCount);
                channel.write(buffer);
            } else {
                ByteBuffer buffer = ByteBuffer.allocate(5);
                buffer.put(0, (byte)-35);
                buffer.putInt(1, this.traceCount);
                channel.write(buffer);
            }
        }

        @Override
        public int sizeInBytes() {
            return this.length;
        }

        @Override
        public int headerSize() {
            if (this.traceCount < 16) {
                return 1;
            }
            if (this.traceCount < 65536) {
                return 3;
            }
            return 5;
        }

        @Override
        public int traceCount() {
            return this.traceCount;
        }

        @Override
        public int representativeCount() {
            return this.representativeCount;
        }

        @Override
        public void setRepresentativeCount(int representativeCount) {
            this.representativeCount = representativeCount;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public void setDispatchRunnable(Runnable flush) {
            this.flush = flush;
        }

        @Override
        public void onDispatched() {
            if (null != this.flush) {
                this.flush.run();
                this.flush = null;
            }
        }

        public void reset() {
            this.buffer.clear();
            this.traceCount = 0;
            this.length = 0;
            this.representativeCount = 0;
        }
    }
}

