/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.core.jfr.DDScopeEvent;
import datadog.trace.core.jfr.DDScopeEventFactory;
import datadog.trace.core.scopemanager.ScopeInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventScopeInterceptor
extends ScopeInterceptor.DelegatingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(EventScopeInterceptor.class);
    private final DDScopeEventFactory eventFactory;

    public EventScopeInterceptor(DDScopeEventFactory eventFactory, ScopeInterceptor delegate) {
        super(delegate);
        this.eventFactory = eventFactory;
    }

    @Override
    public ScopeInterceptor.Scope handleSpan(AgentSpan span) {
        return new EventScope(span.context(), this.delegate.handleSpan(span));
    }

    private class EventScope
    extends ScopeInterceptor.DelegatingScope {
        private final DDScopeEvent event;

        public EventScope(AgentSpan.Context context, ScopeInterceptor.Scope delegate) {
            super(delegate);
            this.event = EventScopeInterceptor.this.eventFactory.create(context);
        }

        @Override
        public void afterActivated() {
            super.afterActivated();
            this.event.start();
        }

        @Override
        public void close() {
            this.event.finish();
            super.close();
        }
    }
}

