/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.taginterceptor;

import datadog.trace.core.DDSpanContext;
import datadog.trace.core.taginterceptor.AbstractTagInterceptor;
import datadog.trace.core.util.FixedSizeCache;

@Deprecated
class DBTypeTagInterceptor
extends AbstractTagInterceptor {
    private static final String OPERATION_SUFFIX = ".query";
    private final FixedSizeCache<String, String> cache = new FixedSizeCache(16);
    private final FixedSizeCache.Creator<String, String> appendOperationSuffix = new FixedSizeCache.Creator<String, String>(){

        @Override
        public String create(String key) {
            return key + DBTypeTagInterceptor.OPERATION_SUFFIX;
        }
    };

    public DBTypeTagInterceptor() {
        super("db.type");
    }

    @Override
    public boolean shouldSetTag(DDSpanContext context, String tag, Object value) {
        String serviceName = String.valueOf(value);
        context.setServiceName(serviceName);
        if ("couchbase".equals(serviceName) || "elasticsearch".equals(serviceName)) {
            return true;
        }
        if ("mongo".equals(serviceName)) {
            context.setSpanType("mongodb");
        } else if ("cassandra".equals(serviceName)) {
            context.setSpanType("cassandra");
        } else if ("memcached".equals(serviceName)) {
            context.setSpanType("memcached");
        } else {
            context.setSpanType("sql");
        }
        String operationName = this.cache.computeIfAbsent(serviceName, this.appendOperationSuffix);
        context.setOperationName(operationName);
        return true;
    }
}

