/*
 * Decompiled with CFR 0.152.
 */
package datadog.common.container;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerInfo {
    private static final Logger log = LoggerFactory.getLogger(ContainerInfo.class);
    private static final Path CGROUP_DEFAULT_PROCFILE = Paths.get("/proc/self/cgroup", new String[0]);
    private static final String UUID_REGEX = "[0-9a-f]{8}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{12}";
    private static final String CONTAINER_REGEX = "[0-9a-f]{64}";
    private static final Pattern LINE_PATTERN = Pattern.compile("(\\d+):([^:]*):(.+)$");
    private static final Pattern POD_PATTERN = Pattern.compile("(?:.+)?pod([0-9a-f]{8}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{12})(?:.slice)?$");
    private static final Pattern CONTAINER_PATTERN = Pattern.compile("(?:.+)?([0-9a-f]{8}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{4}[-_][0-9a-f]{12}|[0-9a-f]{64})(?:.scope)?$");
    private static final ContainerInfo INSTANCE;
    public String containerId;
    public String podId;
    public List<CGroupInfo> cGroups = new ArrayList<CGroupInfo>();

    public static ContainerInfo get() {
        return INSTANCE;
    }

    public static boolean isRunningInContainer() {
        return Files.isReadable(CGROUP_DEFAULT_PROCFILE);
    }

    public static ContainerInfo fromDefaultProcFile() throws IOException, ParseException {
        return ContainerInfo.fromProcFile(CGROUP_DEFAULT_PROCFILE);
    }

    static ContainerInfo fromProcFile(Path path) throws IOException, ParseException {
        String content = new String(Files.readAllBytes(path));
        if (content.isEmpty()) {
            log.debug("Proc file is empty");
            return new ContainerInfo();
        }
        return ContainerInfo.parse(content);
    }

    public static ContainerInfo parse(String cgroupsContent) throws ParseException {
        String[] lines;
        ContainerInfo containerInfo = new ContainerInfo();
        for (String line : lines = cgroupsContent.split("\n")) {
            CGroupInfo cGroupInfo = ContainerInfo.parseLine(line);
            containerInfo.getCGroups().add(cGroupInfo);
            if (cGroupInfo.getPodId() != null) {
                containerInfo.setPodId(cGroupInfo.getPodId());
            }
            if (cGroupInfo.getContainerId() == null) continue;
            containerInfo.setContainerId(cGroupInfo.getContainerId());
        }
        return containerInfo;
    }

    static CGroupInfo parseLine(String line) throws ParseException {
        Matcher matcher = LINE_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new ParseException("Unable to match cgroup", 0);
        }
        CGroupInfo cGroupInfo = new CGroupInfo();
        cGroupInfo.setId(Integer.parseInt(matcher.group(1)));
        cGroupInfo.setControllers(Arrays.asList(matcher.group(2).split(",")));
        String path = matcher.group(3);
        String[] pathParts = path.split("/");
        cGroupInfo.setPath(path);
        if (pathParts.length >= 1) {
            Matcher containerIdMatcher = CONTAINER_PATTERN.matcher(pathParts[pathParts.length - 1]);
            String containerId = containerIdMatcher.matches() ? containerIdMatcher.group(1) : null;
            cGroupInfo.setContainerId(containerId);
        }
        if (pathParts.length >= 2) {
            Matcher podIdMatcher = POD_PATTERN.matcher(pathParts[pathParts.length - 2]);
            String podId = podIdMatcher.matches() ? podIdMatcher.group(1) : null;
            cGroupInfo.setPodId(podId);
        }
        return cGroupInfo;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getPodId() {
        return this.podId;
    }

    public List<CGroupInfo> getCGroups() {
        return this.cGroups;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public void setPodId(String podId) {
        this.podId = podId;
    }

    public void setCGroups(List<CGroupInfo> cGroups) {
        this.cGroups = cGroups;
    }

    static {
        ContainerInfo containerInfo = new ContainerInfo();
        if (ContainerInfo.isRunningInContainer()) {
            try {
                containerInfo = ContainerInfo.fromDefaultProcFile();
            }
            catch (IOException | ParseException e) {
                log.error("Unable to parse proc file");
            }
        }
        INSTANCE = containerInfo;
    }

    public static class CGroupInfo {
        public int id;
        public String path;
        public List<String> controllers;
        public String containerId;
        public String podId;

        public int getId() {
            return this.id;
        }

        public String getPath() {
            return this.path;
        }

        public List<String> getControllers() {
            return this.controllers;
        }

        public String getContainerId() {
            return this.containerId;
        }

        public String getPodId() {
            return this.podId;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public void setControllers(List<String> controllers) {
            this.controllers = controllers;
        }

        public void setContainerId(String containerId) {
            this.containerId = containerId;
        }

        public void setPodId(String podId) {
            this.podId = podId;
        }
    }
}

