/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.processor.rule;

import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;

public class AnalyticsSampleRateRule
implements TraceProcessor.Rule {
    @Override
    public String[] aliases() {
        return new String[]{"AnalyticsSampleRateDecorator"};
    }

    @Override
    public void processSpan(DDSpan span) {
        Object sampleRateValue = span.getAndRemoveTag("_dd1.sr.eausr");
        if (sampleRateValue instanceof Number) {
            span.context().setMetric("_dd1.sr.eausr", (Number)sampleRateValue);
        } else if (sampleRateValue instanceof String) {
            try {
                span.context().setMetric("_dd1.sr.eausr", Double.parseDouble((String)sampleRateValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

