/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.context.ScopeListener;
import datadog.trace.core.scopemanager.ScopeInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListenerScopeInterceptor
extends ScopeInterceptor.DelegatingInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ListenerScopeInterceptor.class);
    final List<ScopeListener> scopeListeners;

    public ListenerScopeInterceptor(List<ScopeListener> scopeListeners, ScopeInterceptor delegate) {
        super(delegate);
        this.scopeListeners = scopeListeners;
    }

    @Override
    public ScopeInterceptor.Scope handleSpan(AgentSpan span) {
        if (this.scopeListeners.isEmpty()) {
            return this.delegate.handleSpan(span);
        }
        return new NotifyingScope(this.delegate.handleSpan(span));
    }

    private class NotifyingScope
    extends ScopeInterceptor.DelegatingScope {
        public NotifyingScope(ScopeInterceptor.Scope delegate) {
            super(delegate);
        }

        @Override
        public void afterActivated() {
            super.afterActivated();
            for (ScopeListener listener : ListenerScopeInterceptor.this.scopeListeners) {
                listener.afterScopeActivated();
            }
        }

        @Override
        public void close() {
            super.close();
            for (ScopeListener listener : ListenerScopeInterceptor.this.scopeListeners) {
                listener.afterScopeClosed();
            }
        }
    }
}

