/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import datadog.trace.api.DDId;
import datadog.trace.core.DDSpan;
import datadog.trace.core.StringTables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public abstract class FormatWriter<DEST> {
    public abstract void writeKey(byte[] var1, DEST var2) throws IOException;

    public abstract void writeListHeader(int var1, DEST var2) throws IOException;

    public abstract void writeListFooter(DEST var1) throws IOException;

    public abstract void writeMapHeader(int var1, DEST var2) throws IOException;

    public abstract void writeMapFooter(DEST var1) throws IOException;

    public void writeTag(byte[] key, String value, DEST destination) throws IOException {
        this.writeString(key, value, destination);
    }

    public abstract void writeString(byte[] var1, String var2, DEST var3) throws IOException;

    public abstract void writeShort(byte[] var1, short var2, DEST var3) throws IOException;

    public abstract void writeByte(byte[] var1, byte var2, DEST var3) throws IOException;

    public abstract void writeInt(byte[] var1, int var2, DEST var3) throws IOException;

    public abstract void writeLong(byte[] var1, long var2, DEST var4) throws IOException;

    public abstract void writeFloat(byte[] var1, float var2, DEST var3) throws IOException;

    public abstract void writeDouble(byte[] var1, double var2, DEST var4) throws IOException;

    public abstract void writeId(byte[] var1, DDId var2, DEST var3) throws IOException;

    public abstract void writeObjectAsString(byte[] var1, Object var2, DEST var3) throws IOException;

    public void writeNumber(byte[] key, Number value, DEST destination) throws IOException {
        if (value instanceof Double) {
            this.writeDouble(key, value.doubleValue(), destination);
        } else if (value instanceof Long) {
            this.writeLong(key, value.longValue(), destination);
        } else if (value instanceof Integer) {
            this.writeInt(key, value.intValue(), destination);
        } else if (value instanceof Float) {
            this.writeFloat(key, value.floatValue(), destination);
        } else if (value instanceof Byte) {
            this.writeByte(key, value.byteValue(), destination);
        } else if (value instanceof Short) {
            this.writeShort(key, value.shortValue(), destination);
        }
    }

    public void writeNumberMap(byte[] key, Map<String, Number> value, DEST destination) throws IOException {
        this.writeKey(key, destination);
        this.writeMapHeader(value.size(), destination);
        for (Map.Entry<String, Number> entry : value.entrySet()) {
            this.writeNumber(FormatWriter.stringToBytes(entry.getKey()), entry.getValue(), destination);
        }
        this.writeMapFooter(destination);
    }

    public void writeMeta(DDSpan span, DEST destination) throws IOException {
        this.writeKey(StringTables.META, destination);
        Map<String, String> baggage = span.context().getBaggageItems();
        Map<String, Object> tags = span.context().getTags();
        this.writeMapHeader(baggage.size() + tags.size(), destination);
        for (Map.Entry<String, String> entry : baggage.entrySet()) {
            if (tags.containsKey(entry.getKey())) continue;
            this.writeTag(FormatWriter.stringToBytes(entry.getKey()), entry.getValue(), destination);
        }
        for (Map.Entry<String, Object> entry : tags.entrySet()) {
            this.writeObjectAsString(FormatWriter.stringToBytes(entry.getKey()), entry.getValue(), destination);
        }
        this.writeMapFooter(destination);
    }

    public void writeTrace(List<DDSpan> trace, DEST destination) throws IOException {
        this.writeListHeader(trace.size(), destination);
        for (DDSpan span : trace) {
            this.writeDDSpan(span, destination);
        }
        this.writeListFooter(destination);
    }

    public void writeDDSpan(DDSpan span, DEST destination) throws IOException {
        this.writeMapHeader(12, destination);
        this.writeTag(StringTables.SERVICE, span.getServiceName(), destination);
        this.writeString(StringTables.NAME, span.getOperationName(), destination);
        this.writeObjectAsString(StringTables.RESOURCE, span.getResourceName(), destination);
        this.writeId(StringTables.TRACE_ID, span.getTraceId(), destination);
        this.writeId(StringTables.SPAN_ID, span.getSpanId(), destination);
        this.writeId(StringTables.PARENT_ID, span.getParentId(), destination);
        this.writeLong(StringTables.START, span.getStartTime(), destination);
        this.writeLong(StringTables.DURATION, span.getDurationNano(), destination);
        this.writeTag(StringTables.TYPE, span.getType(), destination);
        this.writeInt(StringTables.ERROR, span.getError(), destination);
        this.writeNumberMap(StringTables.METRICS, span.getMetrics(), destination);
        this.writeMeta(span, destination);
        this.writeMapFooter(destination);
    }

    private static byte[] stringToBytes(String string) {
        byte[] key = StringTables.getKeyBytesUTF8(string);
        return null == key ? string.getBytes(StandardCharsets.UTF_8) : key;
    }
}

