/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.serialization;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.UTF8BytesString;
import datadog.trace.core.StringTables;
import datadog.trace.core.serialization.FormatWriter;
import datadog.trace.core.util.LRUCache;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.msgpack.core.MessagePacker;

public class MsgpackFormatWriter
extends FormatWriter<MessagePacker> {
    public static MsgpackFormatWriter MSGPACK_WRITER = new MsgpackFormatWriter();
    private final LRUCache<String, byte[]> stringCache = new LRUCache(256, 128);
    private static final byte[] DIGIT_TENS = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DIGIT_ONES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private final byte[] numberByteArray = new byte[20];

    @Override
    public void writeKey(byte[] key, MessagePacker destination) throws IOException {
        destination.packRawStringHeader(key.length);
        destination.addPayload(key);
    }

    @Override
    public void writeListHeader(int size, MessagePacker destination) throws IOException {
        destination.packArrayHeader(size);
    }

    @Override
    public void writeListFooter(MessagePacker destination) {
    }

    @Override
    public void writeMapHeader(int size, MessagePacker destination) throws IOException {
        destination.packMapHeader(size);
    }

    @Override
    public void writeMapFooter(MessagePacker destination) {
    }

    @Override
    public void writeString(byte[] key, String value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        this.cachedWriteString(value, destination);
    }

    @Override
    public void writeTag(byte[] key, String value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        this.writeUTF8Tag(value, destination);
    }

    @Override
    public void writeShort(byte[] key, short value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packShort(value);
    }

    @Override
    public void writeByte(byte[] key, byte value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packByte(value);
    }

    @Override
    public void writeInt(byte[] key, int value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packInt(value);
    }

    @Override
    public void writeLong(byte[] key, long value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packLong(value);
    }

    @Override
    public void writeFloat(byte[] key, float value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packFloat(value);
    }

    @Override
    public void writeDouble(byte[] key, double value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        destination.packDouble(value);
    }

    @Override
    public void writeId(byte[] key, DDId id, MessagePacker destination) throws IOException {
        this.writeLong(key, id.toLong(), destination);
    }

    @Override
    public void writeObjectAsString(byte[] key, Object value, MessagePacker destination) throws IOException {
        this.writeKey(key, destination);
        if (value instanceof Long || value instanceof Integer) {
            this.writeLongAsString(((Number)value).longValue(), destination);
        } else if (value instanceof String) {
            this.cachedWriteString((String)value, destination);
        } else if (value instanceof UTF8BytesString) {
            byte[] bytes = ((UTF8BytesString)value).getUtf8Bytes();
            destination.packRawStringHeader(bytes.length);
            destination.addPayload(bytes);
        } else {
            this.cachedWriteString(String.valueOf(value), destination);
        }
    }

    private void writeUTF8Tag(String value, MessagePacker destination) throws IOException {
        if (null == value) {
            destination.packNil();
        } else {
            byte[] interned = StringTables.getTagBytesUTF8(value);
            if (null != interned) {
                destination.packRawStringHeader(interned.length);
                destination.addPayload(interned);
            } else {
                this.cachedWriteString(value, destination);
            }
        }
    }

    private void cachedWriteString(String value, MessagePacker destination) throws IOException {
        if (null == value) {
            destination.packNil();
        } else {
            int len = value.length();
            if (len > 0 && len <= 32) {
                byte[] bytes = (byte[])this.stringCache.get(value);
                if (bytes == null) {
                    bytes = value.getBytes(StandardCharsets.UTF_8);
                    this.stringCache.put(value, bytes);
                }
                destination.packRawStringHeader(bytes.length);
                destination.addPayload(bytes);
            } else {
                destination.packString(value);
            }
        }
    }

    private void writeLongAsString(long value, MessagePacker destination) throws IOException {
        int iq;
        int r;
        boolean negative;
        int pos = 20;
        long l = value;
        boolean bl = negative = l < 0L;
        if (!negative) {
            l = -l;
        }
        while (l <= Integer.MIN_VALUE) {
            long lq = l / 100L;
            r = (int)(lq * 100L - l);
            l = lq;
            this.numberByteArray[--pos] = DIGIT_ONES[r];
            this.numberByteArray[--pos] = DIGIT_TENS[r];
        }
        int i = (int)l;
        while (i <= -100) {
            iq = i / 100;
            r = iq * 100 - i;
            i = iq;
            this.numberByteArray[--pos] = DIGIT_ONES[r];
            this.numberByteArray[--pos] = DIGIT_TENS[r];
        }
        iq = i / 10;
        r = iq * 10 - i;
        this.numberByteArray[--pos] = (byte)(48 + r);
        if (iq < 0) {
            this.numberByteArray[--pos] = (byte)(48 - iq);
        }
        if (negative) {
            this.numberByteArray[--pos] = 45;
        }
        int len = 20 - pos;
        destination.packRawStringHeader(len);
        destination.addPayload(this.numberByteArray, pos, len);
    }
}

