/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonReader;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(LoggingWriter.class);
    private final TraceProcessor processor = new TraceProcessor();
    private static final JsonAdapter<List<DDSpan>> TRACE_ADAPTER = new Moshi.Builder().add(DDSpanAdapter.FACTORY).build().adapter((Type)Types.newParameterizedType(List.class, (Type[])new Type[]{DDSpan.class}));

    @Override
    public void write(List<DDSpan> trace) {
        trace = this.processor.onTraceComplete(trace);
        try {
            log.info("write(trace): {}", (Object)this.toString(trace));
        }
        catch (Exception e) {
            log.error("error writing(trace): {}", trace);
        }
    }

    private String toString(List<DDSpan> trace) {
        return TRACE_ADAPTER.toJson(trace);
    }

    @Override
    public void incrementTraceCount() {
        log.info("incrementTraceCount()");
    }

    @Override
    public void close() {
        log.info("close()");
    }

    @Override
    public void start() {
        log.info("start()");
    }

    public String toString() {
        return "LoggingWriter { }";
    }

    static class DDSpanAdapter
    extends JsonAdapter<DDSpan> {
        public static final JsonAdapter.Factory FACTORY = new JsonAdapter.Factory(){

            public JsonAdapter<?> create(Type type, Set<? extends Annotation> annotations, Moshi moshi) {
                Class rawType = Types.getRawType((Type)type);
                if (rawType.isAssignableFrom(DDSpan.class)) {
                    return new DDSpanAdapter();
                }
                return null;
            }
        };

        DDSpanAdapter() {
        }

        public DDSpan fromJson(JsonReader reader) {
            throw new UnsupportedOperationException();
        }

        public void toJson(JsonWriter writer, DDSpan span) throws IOException {
            writer.beginObject();
            writer.name("service");
            writer.value(span.getServiceName());
            writer.name("name");
            writer.value(span.getOperationName());
            writer.name("resource");
            writer.value(span.getResourceName().toString());
            writer.name("trace_id");
            writer.value(span.getTraceId().toLong());
            writer.name("span_id");
            writer.value(span.getSpanId().toLong());
            writer.name("parent_id");
            writer.value(span.getParentId().toLong());
            writer.name("start");
            writer.value(span.getStartTime());
            writer.name("duration");
            writer.value(span.getDurationNano());
            writer.name("type");
            writer.value(span.getType());
            writer.name("error");
            writer.value((long)span.getError());
            writer.name("metrics");
            writer.beginObject();
            for (Map.Entry<String, Number> entry : span.getMetrics().entrySet()) {
                writer.name(entry.getKey());
                writer.value(entry.getValue());
            }
            writer.endObject();
            writer.name("meta");
            writer.beginObject();
            Map<String, Object> tags = span.getTags();
            for (Map.Entry<String, String> entry : span.context().getBaggageItems().entrySet()) {
                if (tags.containsKey(entry.getKey())) continue;
                writer.name(entry.getKey());
                writer.value(entry.getValue());
            }
            for (Map.Entry<String, Object> entry : tags.entrySet()) {
                writer.name(entry.getKey());
                writer.value(String.valueOf(entry.getValue()));
            }
            writer.endObject();
            writer.endObject();
        }
    }
}

