/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.propagation;

import datadog.trace.api.DDId;
import datadog.trace.bootstrap.instrumentation.api.AgentPropagation;
import datadog.trace.core.DDSpanContext;
import datadog.trace.core.propagation.ExtractedContext;
import datadog.trace.core.propagation.HttpCodec;
import datadog.trace.core.propagation.TagContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class B3HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(B3HttpCodec.class);
    private static final String TRACE_ID_KEY = "X-B3-TraceId";
    private static final String SPAN_ID_KEY = "X-B3-SpanId";
    private static final String SAMPLING_PRIORITY_KEY = "X-B3-Sampled";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;

    private B3HttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(), mapping.getValue());
            }
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.Getter<C> getter) {
            try {
                Map<String, String> tags = Collections.emptyMap();
                DDId traceId = DDId.ZERO;
                DDId spanId = DDId.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                for (String uncasedKey : getter.keys(carrier)) {
                    String key = uncasedKey.toLowerCase();
                    String value = HttpCodec.firstHeaderValue(getter.get(carrier, uncasedKey));
                    if (value == null) continue;
                    if (B3HttpCodec.TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        int length = value.length();
                        if (length > 32) {
                            log.debug("Header {} exceeded max length of 32: {}", (Object)B3HttpCodec.TRACE_ID_KEY, (Object)value);
                            traceId = DDId.ZERO;
                            continue;
                        }
                        String trimmedValue = length > 16 ? value.substring(length - 16) : value;
                        traceId = DDId.fromHex((String)trimmedValue);
                    } else if (B3HttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = DDId.fromHex((String)value);
                    } else if (B3HttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = this.convertSamplingPriority(value);
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!DDId.ZERO.equals((Object)traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, null, Collections.emptyMap(), tags);
                    context.lockSamplingPriority();
                    log.debug("{} - Parent context extracted", (Object)context.getTraceId());
                    return context;
                }
                if (!tags.isEmpty()) {
                    log.debug("Tags context extracted");
                    return new TagContext(null, tags);
                }
            }
            catch (RuntimeException e) {
                log.debug("Exception when extracting context", (Throwable)e);
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            block3: {
                try {
                    setter.set(carrier, B3HttpCodec.TRACE_ID_KEY, context.getTraceId().toHexString().toLowerCase());
                    setter.set(carrier, B3HttpCodec.SPAN_ID_KEY, context.getSpanId().toHexString().toLowerCase());
                    if (context.lockSamplingPriority()) {
                        setter.set(carrier, B3HttpCodec.SAMPLING_PRIORITY_KEY, this.convertSamplingPriority(context.getSamplingPriority()));
                    }
                    log.debug("{} - B3 parent context injected", (Object)context.getTraceId());
                }
                catch (NumberFormatException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug("Cannot parse context id(s): {} {}", new Object[]{context.getTraceId(), context.getSpanId(), e});
                }
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

