/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import com.timgroup.statsd.StatsDClient;
import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentScopeManager;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import datadog.trace.context.ScopeListener;
import datadog.trace.context.TraceScope;
import datadog.trace.core.jfr.DDScopeEventFactory;
import datadog.trace.core.scopemanager.EventScopeInterceptor;
import datadog.trace.core.scopemanager.ListenerScopeInterceptor;
import datadog.trace.core.scopemanager.ScopeInterceptor;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuableScopeManager
extends ScopeInterceptor.DelegatingInterceptor
implements AgentScopeManager {
    private static final Logger log = LoggerFactory.getLogger(ContinuableScopeManager.class);
    static final ThreadLocal<ContinuableScope> tlsScope = new ThreadLocal();
    private final List<ScopeListener> scopeListeners;
    private final int depthLimit;
    private final StatsDClient statsDClient;
    private final boolean strictMode;

    public ContinuableScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory, StatsDClient statsDClient, boolean strictMode) {
        this(depthLimit, scopeEventFactory, statsDClient, strictMode, new CopyOnWriteArrayList<ScopeListener>());
    }

    private ContinuableScopeManager(int depthLimit, DDScopeEventFactory scopeEventFactory, StatsDClient statsDClient, boolean strictMode, List<ScopeListener> scopeListeners) {
        super(new EventScopeInterceptor(scopeEventFactory, new ListenerScopeInterceptor(scopeListeners, null)));
        this.depthLimit = depthLimit == 0 ? Integer.MAX_VALUE : depthLimit;
        this.statsDClient = statsDClient;
        this.strictMode = strictMode;
        this.scopeListeners = scopeListeners;
    }

    @Override
    public AgentScope activate(AgentSpan span, ScopeSource source) {
        int currentDepth;
        ContinuableScope active = tlsScope.get();
        if (active != null && active.span().equals(span)) {
            return active.incrementReferences();
        }
        int n = currentDepth = active == null ? 0 : active.depth();
        if (this.depthLimit <= currentDepth) {
            log.debug("Scope depth limit exceeded ({}).  Returning NoopScope.", (Object)currentDepth);
            return AgentTracer.NoopAgentScope.INSTANCE;
        }
        return this.handleSpan(null, span, source);
    }

    @Override
    public ScopeInterceptor.Scope handleSpan(AgentSpan span) {
        return this.handleSpan(null, span, ScopeSource.INSTRUMENTATION);
    }

    private ScopeInterceptor.Scope handleSpan(Continuation continuation, AgentSpan span, ScopeSource source) {
        ContinuableScope scope = new ContinuableScope(continuation, this.delegate.handleSpan(span), source);
        tlsScope.set(scope);
        scope.afterActivated();
        return scope;
    }

    @Override
    public TraceScope active() {
        return tlsScope.get();
    }

    @Override
    public AgentSpan activeSpan() {
        ScopeInterceptor.Scope active = tlsScope.get();
        return active == null ? null : active.span();
    }

    public void addScopeListener(ScopeListener listener) {
        this.scopeListeners.add(listener);
    }

    private class Continuation
    implements AgentScope.Continuation {
        public WeakReference<AgentScope.Continuation> ref;
        private final AgentSpan spanUnderScope;
        private final ScopeSource source;
        private final AgentTrace trace;
        private final AtomicBoolean used = new AtomicBoolean(false);

        private Continuation(AgentSpan spanUnderScope, ScopeSource source) {
            this.spanUnderScope = spanUnderScope;
            this.source = source;
            this.trace = spanUnderScope.context().getTrace();
        }

        private Continuation register() {
            this.trace.registerContinuation(this);
            return this;
        }

        public AgentScope activate() {
            if (this.used.compareAndSet(false, true)) {
                ScopeInterceptor.Scope scope = ContinuableScopeManager.this.handleSpan(this, this.spanUnderScope, this.source);
                log.debug("t_id={} -> activating continuation {}", (Object)this.spanUnderScope.getTraceId(), (Object)this);
                return scope;
            }
            log.debug("Failed to activate continuation. Reusing a continuation not allowed. Spans may be reported separately.");
            return ContinuableScopeManager.this.handleSpan(null, this.spanUnderScope, this.source);
        }

        public void cancel() {
            if (this.used.compareAndSet(false, true)) {
                this.trace.cancelContinuation(this);
            } else {
                log.debug("Failed to close continuation {}. Already used.", (Object)this);
            }
        }

        @Override
        public boolean isRegistered() {
            return this.ref != null;
        }

        @Override
        public WeakReference<AgentScope.Continuation> register(ReferenceQueue referenceQueue) {
            this.ref = new WeakReference<Continuation>(this, referenceQueue);
            return this.ref;
        }

        @Override
        public void cancel(Set<WeakReference<AgentScope.Continuation>> weakReferences) {
            weakReferences.remove(this.ref);
            this.ref.clear();
            this.ref = null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + "->" + this.spanUnderScope;
        }
    }

    private class ContinuableScope
    extends ScopeInterceptor.DelegatingScope
    implements ScopeInterceptor.Scope {
        private final ContinuableScope toRestore;
        private final Continuation continuation;
        private final AtomicBoolean isAsyncPropagating;
        private final int depth;
        private final ScopeSource source;
        private final AtomicInteger referenceCount;

        ContinuableScope(Continuation continuation, ScopeInterceptor.Scope delegate, ScopeSource source) {
            super(delegate);
            this.isAsyncPropagating = new AtomicBoolean(false);
            this.referenceCount = new AtomicInteger(1);
            assert (delegate.span() != null);
            this.continuation = continuation;
            this.toRestore = tlsScope.get();
            this.depth = this.toRestore == null ? 0 : this.toRestore.depth() + 1;
            this.source = source;
        }

        @Override
        public void close() {
            if (this.referenceCount.decrementAndGet() > 0) {
                return;
            }
            if (tlsScope.get() != this) {
                log.debug("Tried to close {} scope when {} is on top. Ignoring!", (Object)this, (Object)tlsScope.get());
                ContinuableScopeManager.this.statsDClient.incrementCounter("scope.close.error", new String[0]);
                if (this.source == ScopeSource.MANUAL) {
                    ContinuableScopeManager.this.statsDClient.incrementCounter("scope.user.close.error", new String[0]);
                    if (ContinuableScopeManager.this.strictMode) {
                        throw new RuntimeException("Tried to close scope when not on top");
                    }
                }
                return;
            }
            if (null != this.continuation) {
                this.span().context().getTrace().cancelContinuation(this.continuation);
            }
            tlsScope.set(this.toRestore);
            super.close();
        }

        public int depth() {
            return this.depth;
        }

        public ScopeInterceptor.Scope incrementReferences() {
            this.referenceCount.incrementAndGet();
            return this;
        }

        @Override
        public boolean isAsyncPropagating() {
            return this.isAsyncPropagating.get();
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.isAsyncPropagating.set(value);
        }

        @Override
        public Continuation capture() {
            if (this.isAsyncPropagating()) {
                Continuation continuation = new Continuation(this.span(), this.source);
                return continuation.register();
            }
            return null;
        }

        public String toString() {
            return super.toString() + "->" + this.span();
        }
    }
}

