/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.scopemanager;

import datadog.trace.bootstrap.instrumentation.api.AgentScope;
import datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import datadog.trace.context.TraceScope;

interface ScopeInterceptor {
    public Scope handleSpan(AgentSpan var1);

    public static final class TerminalInterceptor
    implements ScopeInterceptor {
        @Override
        public Scope handleSpan(AgentSpan span) {
            return new TerminalScope(span);
        }

        private static class TerminalScope
        implements Scope {
            private final AgentSpan span;

            TerminalScope(AgentSpan span) {
                this.span = span;
            }

            @Override
            public void afterActivated() {
            }

            @Override
            public AgentSpan span() {
                return this.span;
            }

            @Override
            public void setAsyncPropagation(boolean value) {
            }

            public TraceScope.Continuation capture() {
                return null;
            }

            @Override
            public void close() {
            }

            public boolean isAsyncPropagating() {
                return false;
            }
        }
    }

    public static abstract class DelegatingScope
    implements Scope {
        protected final Scope delegate;

        public DelegatingScope(Scope delegate) {
            this.delegate = delegate;
        }

        @Override
        public void afterActivated() {
            this.delegate.afterActivated();
        }

        @Override
        public AgentSpan span() {
            return this.delegate.span();
        }

        @Override
        public void setAsyncPropagation(boolean value) {
            this.delegate.setAsyncPropagation(value);
        }

        public TraceScope.Continuation capture() {
            return this.delegate.capture();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        public boolean isAsyncPropagating() {
            return this.delegate.isAsyncPropagating();
        }
    }

    public static abstract class DelegatingInterceptor
    implements ScopeInterceptor {
        protected final ScopeInterceptor delegate;

        protected DelegatingInterceptor(ScopeInterceptor delegate) {
            this.delegate = delegate != null ? delegate : new TerminalInterceptor();
        }
    }

    public static interface Scope
    extends AgentScope {
        public void afterActivated();
    }
}

