/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.core.util;

import datadog.trace.api.Config;
import datadog.trace.core.util.ThreadCpuTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadCpuTimeAccess {
    private static final Logger log = LoggerFactory.getLogger(ThreadCpuTimeAccess.class);
    private static volatile ThreadCpuTimeProvider cpuTimeProvider = ThreadCpuTimeProvider.NONE;

    public static void disableJmx() {
        log.debug("Disabling JMX thread CPU time provider");
        cpuTimeProvider = ThreadCpuTimeProvider.NONE;
    }

    public static void enableJmx() {
        if (!Config.get().isProfilingEnabled()) {
            log.debug("Will not enable thread CPU time access. Profiling is disabled.");
            return;
        }
        try {
            log.debug("Enabling JMX thread CPU time provider");
            cpuTimeProvider = (ThreadCpuTimeProvider)Class.forName("datadog.trace.core.util.JmxThreadCpuTimeProvider").getField("INSTANCE").get(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            log.info("Unable to initialize JMX thread CPU time provider", (Throwable)e);
        }
    }

    public static long getCurrentThreadCpuTime() {
        return cpuTimeProvider.getThreadCpuTime();
    }
}

