/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.timgroup.statsd.NoOpStatsDClient;
import com.timgroup.statsd.StatsDClient;
import datadog.trace.api.ConfigDefaults;
import datadog.trace.common.writer.Writer;
import datadog.trace.common.writer.ddagent.DDAgentApi;
import datadog.trace.common.writer.ddagent.DDAgentResponseListener;
import datadog.trace.common.writer.ddagent.Monitor;
import datadog.trace.common.writer.ddagent.TraceProcessingDisruptor;
import datadog.trace.core.DDSpan;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDAgentWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(DDAgentWriter.class);
    private static final int DISRUPTOR_BUFFER_SIZE = 1024;
    private final DDAgentApi api;
    private final TraceProcessingDisruptor traceProcessingDisruptor;
    private final AtomicInteger traceCount = new AtomicInteger(0);
    private volatile boolean closed;
    public final Monitor monitor;

    private DDAgentWriter(DDAgentApi agentApi, String agentHost, int traceAgentPort, String unixDomainSocket, long timeoutMillis, int traceBufferSize, Monitor monitor, int flushFrequencySeconds) {
        this.api = agentApi != null ? agentApi : new DDAgentApi(agentHost, traceAgentPort, unixDomainSocket, timeoutMillis);
        this.monitor = monitor;
        this.traceProcessingDisruptor = new TraceProcessingDisruptor(traceBufferSize, monitor, this, this.api, flushFrequencySeconds, TimeUnit.SECONDS, flushFrequencySeconds > 0);
    }

    public void addResponseListener(DDAgentResponseListener listener) {
        this.api.addResponseListener(listener);
    }

    public final long getDisruptorCapacity() {
        return this.traceProcessingDisruptor.getDisruptorCapacity();
    }

    public final long getDisruptorUtilizedCapacity() {
        return this.getDisruptorCapacity() - this.getDisruptorRemainingCapacity();
    }

    public final long getDisruptorRemainingCapacity() {
        return this.traceProcessingDisruptor.getDisruptorRemainingCapacity();
    }

    @Override
    public void write(List<DDSpan> trace) {
        if (!this.closed) {
            int representativeCount = trace.isEmpty() || !trace.get(0).isRootSpan() ? 1 : this.traceCount.getAndSet(0) + 1;
            boolean published = this.traceProcessingDisruptor.publish(trace, representativeCount);
            if (published) {
                this.monitor.onPublish(this, trace);
            } else {
                this.traceCount.addAndGet(representativeCount);
                log.debug("Trace written to overfilled buffer. Counted but dropping trace: {}", trace);
                this.monitor.onFailedPublish(this, trace);
            }
        } else {
            log.debug("Trace written after shutdown. Ignoring trace: {}", trace);
            this.monitor.onFailedPublish(this, trace);
        }
    }

    public boolean flush() {
        if (!this.closed && this.traceProcessingDisruptor.flush(1L, TimeUnit.SECONDS)) {
            this.monitor.onFlush(this, false);
            return true;
        }
        return false;
    }

    @Override
    public void incrementTraceCount() {
        this.traceCount.incrementAndGet();
    }

    public DDAgentApi getApi() {
        return this.api;
    }

    @Override
    public void start() {
        if (!this.closed) {
            this.traceProcessingDisruptor.start();
            this.monitor.onStart(this);
        }
    }

    @Override
    public void close() {
        boolean flushed = this.flush();
        this.closed = true;
        this.traceProcessingDisruptor.close();
        this.monitor.onShutdown(this, flushed);
    }

    public static DDAgentWriterBuilder builder() {
        return new DDAgentWriterBuilder();
    }

    public static class DDAgentWriterBuilder {
        private DDAgentApi agentApi;
        String agentHost = "localhost";
        int traceAgentPort = 8126;
        String unixDomainSocket = ConfigDefaults.DEFAULT_AGENT_UNIX_DOMAIN_SOCKET;
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        int traceBufferSize = 1024;
        Monitor monitor = new Monitor((StatsDClient)new NoOpStatsDClient());
        int flushFrequencySeconds = 1;

        DDAgentWriterBuilder() {
        }

        public DDAgentWriterBuilder agentApi(DDAgentApi agentApi) {
            this.agentApi = agentApi;
            return this;
        }

        public DDAgentWriterBuilder agentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public DDAgentWriterBuilder traceAgentPort(int traceAgentPort) {
            this.traceAgentPort = traceAgentPort;
            return this;
        }

        public DDAgentWriterBuilder unixDomainSocket(String unixDomainSocket) {
            this.unixDomainSocket = unixDomainSocket;
            return this;
        }

        public DDAgentWriterBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDAgentWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDAgentWriterBuilder monitor(Monitor monitor) {
            this.monitor = monitor;
            return this;
        }

        public DDAgentWriterBuilder flushFrequencySeconds(int flushFrequencySeconds) {
            this.flushFrequencySeconds = flushFrequencySeconds;
            return this;
        }

        public DDAgentWriter build() {
            return new DDAgentWriter(this.agentApi, this.agentHost, this.traceAgentPort, this.unixDomainSocket, this.timeoutMillis, this.traceBufferSize, this.monitor, this.flushFrequencySeconds);
        }

        public String toString() {
            return "DDAgentWriter.DDAgentWriterBuilder(agentApi=" + this.agentApi + ", agentHost=" + this.agentHost + ", traceAgentPort=" + this.traceAgentPort + ", unixDomainSocket=" + this.unixDomainSocket + ", timeoutMillis=" + this.timeoutMillis + ", traceBufferSize=" + this.traceBufferSize + ", monitor=" + this.monitor + ", flushFrequencySeconds=" + this.flushFrequencySeconds + ")";
        }
    }
}

