/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.common.writer;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.JsonWriter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.Types;
import datadog.trace.common.writer.DDSpanJsonAdapter;
import datadog.trace.common.writer.Writer;
import datadog.trace.core.DDSpan;
import datadog.trace.core.processor.TraceProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class PrintingWriter
implements Writer {
    private final TraceProcessor processor = new TraceProcessor();
    private final JsonWriter jsonWriter;
    private final JsonAdapter<Map<String, List<DDSpan>>> jsonAdapter;

    public PrintingWriter(OutputStream outputStream, boolean hexIds) {
        this.jsonWriter = JsonWriter.of((BufferedSink)Okio.buffer((Sink)Okio.sink((OutputStream)outputStream)));
        this.jsonAdapter = new Moshi.Builder().add(DDSpanJsonAdapter.buildFactory(hexIds)).build().adapter((Type)Types.newParameterizedType(Map.class, (Type[])new Type[]{String.class, Types.newParameterizedType(List.class, (Type[])new Type[]{DDSpan.class})}));
    }

    @Override
    public void write(List<DDSpan> trace) {
        List<DDSpan> processedTrace = this.processor.onTraceComplete(trace);
        try {
            this.jsonAdapter.toJson(this.jsonWriter, Collections.singletonMap("traces", processedTrace));
            this.jsonWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void close() {
    }

    @Override
    public void incrementTraceCount() {
    }
}

